/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.event.ClientEvents;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderUtil {
    public static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderStateShard.TransparencyStateShard NORMAL_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderType GLOWING_SPRITE = RenderType.m_173215_((String)"eidolon:glowing_sprite", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingSpriteShader)).m_110691_(false));
    public static final RenderType GLOWING = RenderType.m_173215_((String)"eidolon:glowing", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(ADDITIVE_TRANSPARENCY).m_173292_(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingShader)).m_110691_(false));
    public static final RenderType DELAYED_PARTICLE = RenderType.m_173215_((String)"eidolon:delayed_particle", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110685_(NORMAL_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118260_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientRegistry::getSpriteParticleShader)).m_110691_(false));
    public static final RenderType GLOWING_PARTICLE = RenderType.m_173215_((String)"eidolon:glowing_particle", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118260_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingParticleShader)).m_110691_(false));
    public static final RenderType GLOWING_BLOCK_PARTICLE = RenderType.m_173215_((String)"eidolon:glowing_particle", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientRegistry::getGlowingParticleShader)).m_110691_(false));
    public static final RenderType VAPOR_TRANSLUCENT = RenderType.m_173215_((String)"eidolon:vapor_translucent", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(new RenderStateShard.LightmapStateShard(false)).m_110685_(NORMAL_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientRegistry::getVaporShader)).m_110691_(false));
    static double ticks = 0.0;
    private static final float ROOT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.m_6299_(GLOWING_SPRITE);
        float f7 = sprite.m_118409_();
        float f8 = sprite.m_118410_();
        float f5 = sprite.m_118411_();
        float f6 = sprite.m_118412_();
        Matrix4f mat = mStack.m_85850_().m_252922_();
        builder.m_252986_(mat, (float)x, (float)y + (float)h, 0.0f).m_7421_(f7, f6).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(mat, (float)x + (float)w, (float)y + (float)h, 0.0f).m_7421_(f8, f6).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(mat, (float)x + (float)w, (float)y, 0.0f).m_7421_(f8, f5).m_85950_(r, g, b, a).m_5752_();
        builder.m_252986_(mat, (float)x, (float)y, 0.0f).m_7421_(f7, f5).m_85950_(r, g, b, a).m_5752_();
    }

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, TextureAtlasSprite sprite) {
        RenderUtil.litQuad(mStack, buffer, x, y, w, h, r, g, b, 1.0f, sprite);
    }

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, float u, float v, float uw, float vh) {
        VertexConsumer builder = buffer.m_6299_(GLOWING_SPRITE);
        Matrix4f mat = mStack.m_85850_().m_252922_();
        builder.m_252986_(mat, (float)x, (float)y + (float)h, 0.0f).m_7421_(u, v + vh).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_252986_(mat, (float)x + (float)w, (float)y + (float)h, 0.0f).m_7421_(u + uw, v + vh).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_252986_(mat, (float)x + (float)w, (float)y, 0.0f).m_7421_(u + uw, v).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_252986_(mat, (float)x, (float)y, 0.0f).m_7421_(u, v).m_85950_(r, g, b, 1.0f).m_5752_();
    }

    public static void litBillboard(PoseStack mStack, MultiBufferSource buffer, double x, double y, double z, float r, float g, float b, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.m_6299_(GLOWING_SPRITE);
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 vector3d = renderInfo.m_90583_();
        float partialTicks = Minecraft.m_91087_().m_91296_();
        float f = (float)x;
        float f1 = (float)y;
        float f2 = (float)z;
        Quaternionf quaternion = renderInfo.m_253121_();
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)};
        float f4 = 1.0f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = sprite.m_118409_();
        float f8 = sprite.m_118410_();
        float f5 = sprite.m_118411_();
        float f6 = sprite.m_118412_();
        Matrix4f mat = mStack.m_85850_().m_252922_();
        builder.m_252986_(mat, avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).m_7421_(f8, f6).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_252986_(mat, avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).m_7421_(f8, f5).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_252986_(mat, avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).m_7421_(f7, f5).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_252986_(mat, avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).m_7421_(f7, f6).m_85950_(r, g, b, 1.0f).m_5752_();
    }

    public static void dragon(PoseStack mStack, MultiBufferSource buf, double x, double y, double z, float radius, float r, float g, float b) {
        float f5 = 0.5f;
        float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
        Random random = new Random(432L);
        VertexConsumer builder = buf.m_6299_(GLOWING);
        mStack.m_85836_();
        mStack.m_85837_(x, y, z);
        float rotation = ClientEvents.getClientTicks() / 200.0f;
        int i = 0;
        while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
            mStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
            mStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + rotation * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = mStack.m_85850_().m_252922_();
            float alpha = 1.0f - f7;
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, -ROOT_3 * (f4 *= 0.05f * radius), f3 *= 0.05f * radius, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, ROOT_3 * f4, f3, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, ROOT_3 * f4, f3, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.0f, f3, f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            builder.m_252986_(mat, 0.0f, f3, f4).m_85950_(r, g, b, 0.0f).m_5752_();
            builder.m_252986_(mat, -ROOT_3 * f4, f3, -0.5f * f4).m_85950_(r, g, b, 0.0f).m_5752_();
            ++i;
        }
        mStack.m_85849_();
    }

    public static void vaporCube(PoseStack mStack, VertexConsumer builder, TextureAtlasSprite sprite, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, boolean nx, boolean px, boolean ny, boolean py, boolean nz, boolean pz) {
        Matrix4f mat = mStack.m_85850_().m_252922_();
        if (py) {
            builder.m_252986_(mat, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(x1 * 16.0f))).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(x1 * 16.0f))).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(x2 * 16.0f))).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(x2 * 16.0f))).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (ny) {
            builder.m_252986_(mat, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(x1 * 16.0f))).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(x1 * 16.0f))).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(x2 * 16.0f))).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(x2 * 16.0f))).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        }
        if (nz) {
            builder.m_252986_(mat, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x1 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(mat, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x2 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(mat, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x2 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_252986_(mat, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x1 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (pz) {
            builder.m_252986_(mat, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x1 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(mat, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x2 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(mat, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x2 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_252986_(mat, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(x1 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (nx) {
            builder.m_252986_(mat, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (px) {
            builder.m_252986_(mat, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(y1 * 16.0f))).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z2 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(mat, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(sprite.m_118367_((double)(z1 * 16.0f)), sprite.m_118393_((double)(y2 * 16.0f))).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        }
    }
}

