/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.farm_and_charm.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.farm_and_charm.core.block.entity.RoasterBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ScreenhandlerTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public class RoasterGuiHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData propertyDelegate;

    public RoasterGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(2));
    }

    public RoasterGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenhandlerTypeRegistry.ROASTER_SCREEN_HANDLER.get(), syncId);
        this.inventory = inventory;
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(propertyDelegate);
        this.buildBlockEntityContainer();
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer() {
        this.m_38897_(new ExtendedSlot(this.inventory, 6, 95, 55, stack -> stack.m_204117_(TagRegistry.CONTAINER)));
        for (int row = 0; row < 2; ++row) {
            for (int slot = 0; slot < 3; ++slot) {
                this.m_38897_(new Slot(this.inventory, slot + row * 3, 30 + slot * 18, 17 + row * 18));
            }
        }
        this.m_38897_(new Slot(this.inventory, 7, 124, 28){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = RoasterBlockEntity.getMaxRoastingTime();
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / totalProgress + 1;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            ItemStack copy = stack.m_41777_();
            if (index >= 0 && index <= 5 ? !this.m_38903_(stack, 8, 44, true) : (index == 6 ? !this.m_38903_(stack, 8, 44, true) : (index == 7 ? !this.m_38903_(stack, 8, 44, true) : (stack.m_204117_(TagRegistry.CONTAINER) ? !this.m_38903_(stack, 6, 7, false) : !this.m_38903_(stack, 0, 6, false))))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, stack);
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }
}

