/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Arrays;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.client.util.ClientUtil;
import net.satisfy.farm_and_charm.core.block.StoveBlock;
import net.satisfy.farm_and_charm.core.block.entity.StoveBlockEntity;

public class StoveBlockRenderer
implements BlockEntityRenderer<StoveBlockEntity> {
    public StoveBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StoveBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)StoveBlock.FACING);
        Vec3 baseOffset = new Vec3(0.5, 1.0, 0.5);
        Vec3 directionOffset = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(0.3);
        double downOffset = -0.575;
        Vec3 inputSlotOffset = new Vec3(direction == Direction.NORTH || direction == Direction.WEST ? 0.15 : -0.15, downOffset, direction == Direction.NORTH || direction == Direction.EAST ? 0.15 : -0.15);
        this.renderSlots(blockEntity, poseStack, baseOffset, directionOffset, inputSlotOffset, bufferSource);
        this.renderOutput(blockEntity, poseStack, baseOffset, directionOffset, bufferSource);
    }

    private void renderSlots(StoveBlockEntity blockEntity, PoseStack poseStack, Vec3 baseOffset, Vec3 directionOffset, Vec3 slotOffset, MultiBufferSource bufferSource) {
        int[] slots = blockEntity.getIngredientSlots();
        int nonEmptyCount = (int)Arrays.stream(slots).filter(slot -> !blockEntity.m_8020_(slot).m_41619_()).count();
        double ySpacing = 0.02;
        double yOffset = 0.1;
        for (int slot2 : slots) {
            ItemStack stack = blockEntity.m_8020_(slot2);
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            Vec3 position = baseOffset.m_82549_(directionOffset).m_82549_(slotOffset).m_82520_(0.0, yOffset, 0.0);
            poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f * (float)(nonEmptyCount - 1)));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            ClientUtil.renderItem(stack, poseStack, bufferSource, blockEntity);
            poseStack.m_85849_();
            yOffset += ySpacing;
        }
    }

    private void renderOutput(StoveBlockEntity blockEntity, PoseStack poseStack, Vec3 baseOffset, Vec3 directionOffset, MultiBufferSource bufferSource) {
        ItemStack outputStack = blockEntity.m_8020_(blockEntity.getOutputSlot());
        if (!outputStack.m_41619_()) {
            poseStack.m_85836_();
            Vec3 position = baseOffset.m_82549_(directionOffset).m_82520_(0.0, -0.49, 0.0);
            poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            ClientUtil.renderItem(outputStack, poseStack, bufferSource, blockEntity);
            poseStack.m_85849_();
        }
    }
}

