/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.entity.DrivableEntity;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.CartWheel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTowableEntity
extends Entity {
    public static final String DRIVER = "Driver";
    @Nullable
    public Entity driver;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private int soundCooldownTicks = 0;
    final CartWheel leftWheel;
    final CartWheel rightWheel;
    private float health = 10.0f;
    private int wobbleTicks = 0;
    private float wobbleDirection = 0.0f;

    public AbstractTowableEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.2f);
        this.leftWheel = new CartWheel(this, -1.5f);
        this.rightWheel = new CartWheel(this, 1.5f);
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    @Nullable
    public Entity getDriver() {
        return this.driver;
    }

    protected void removeDriver() {
        this.driver = null;
    }

    public boolean canAddDriver() {
        return !this.hasDriver();
    }

    public boolean addDriver(Entity entity) {
        if (entity instanceof Player) {
            List entities = this.m_9236_().m_45976_(Entity.class, entity.m_20191_().m_82400_(100.0));
            for (Entity ent : entities) {
                DrivableEntity drivable;
                if (!(ent instanceof DrivableEntity) || !(drivable = (DrivableEntity)ent).hasDriver()) continue;
                assert (drivable.getDriver() != null);
                if (!drivable.getDriver().equals((Object)entity)) continue;
                return false;
            }
        }
        if (!this.hasDriver() && this.canAddDriver()) {
            this.driver = entity;
            return true;
        }
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_5829_() {
        return !this.m_213877_();
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.hasDriver()) {
            assert (this.getDriver() != null);
            compoundTag.m_128405_(DRIVER, this.getDriver().m_19879_());
        }
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_(DRIVER)) {
            this.driver = this.m_9236_().m_6815_(compoundTag.m_128451_(DRIVER));
        }
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand interactionHand) {
        if (this.hasDriver()) {
            this.removeDriver();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12635_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        boolean added = this.addDriver((Entity)player);
        if (added) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12633_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Vec3 getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (this.driver == null) {
            return Vec3.f_82478_;
        }
        if (delta == 1.0f) {
            x = this.driver.m_20185_() - this.m_20185_();
            y = this.driver.m_20186_() - this.m_20186_();
            z = this.driver.m_20189_() - this.m_20189_();
        } else {
            x = Mth.m_14139_((double)delta, (double)this.driver.f_19790_, (double)this.driver.m_20185_()) - Mth.m_14139_((double)delta, (double)this.f_19790_, (double)this.m_20185_());
            y = Mth.m_14139_((double)delta, (double)this.driver.f_19791_, (double)this.driver.m_20186_()) - Mth.m_14139_((double)delta, (double)this.f_19791_, (double)this.m_20186_());
            z = Mth.m_14139_((double)delta, (double)this.driver.f_19792_, (double)this.driver.m_20189_()) - Mth.m_14139_((double)delta, (double)this.f_19792_, (double)this.m_20189_());
        }
        float yaw = (float)Math.toRadians(this.driver.m_146908_());
        float nx = -Mth.m_14031_((float)yaw);
        float nz = Mth.m_14089_((float)yaw);
        double r = this.getOffsetRadius();
        return new Vec3(x + (double)nx * r, -y, z + (double)nz * r);
    }

    public void handleRotation(Vec3 target) {
        this.m_146922_(AbstractTowableEntity.getYaw(target));
        this.m_146926_(AbstractTowableEntity.getPitch(target));
    }

    public static float getYaw(Vec3 vec) {
        return Mth.m_14177_((float)((float)Math.toDegrees(-Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_))));
    }

    public static float getPitch(Vec3 vec) {
        return Mth.m_14177_((float)((float)Math.toDegrees(Mth.m_14136_((double)vec.f_82480_, (double)Mth.m_14116_((float)((float)(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_)))))));
    }

    public void pulledTick() {
        if (this.driver == null) {
            return;
        }
        Vec3 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        if (this.driver.m_20096_()) {
            targetVec = new Vec3(targetVec.f_82479_, 0.0, targetVec.f_82481_);
        }
        double targetVecLength = targetVec.m_82553_();
        double r = this.getOffsetRadius();
        double relativeSpacing = this.getRelativeSpacing();
        double diff = targetVecLength - relativeSpacing;
        Vec3 move = Math.abs(diff) < r ? this.m_20184_() : this.m_20184_().m_82549_(targetVec.m_82546_(targetVec.m_82541_().m_82490_(relativeSpacing + r * Math.signum(diff))));
        this.m_6853_(true);
        this.m_6478_(MoverType.SELF, move);
        if (!this.m_6084_()) {
            return;
        }
        this.addStats();
        if (!this.m_9236_().f_46443_ && (targetVec = this.getRelativeTargetVec(1.0f)).m_82553_() > relativeSpacing + 1.0) {
            this.driver = null;
        }
        this.updatePassengers();
    }

    public void updatePassengers() {
        for (Entity passenger : this.m_20197_()) {
            this.m_7332_(passenger);
        }
    }

    private void addStats() {
    }

    void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            this.m_146922_((float)((double)this.m_146908_() + Mth.m_14175_((double)(this.lerpYaw - (double)this.m_146908_())) / (double)this.lerpSteps));
            this.m_146926_((float)((double)this.m_146909_() + (this.lerpPitch - (double)this.m_146909_()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.m_6853_(true);
            this.m_6478_(MoverType.SELF, new Vec3(dx, dy, dz));
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
        }
        super.m_8119_();
        this.tickLerp();
        if (this.driver != null) {
            this.pulledTick();
        }
        this.leftWheel.tick();
        this.rightWheel.tick();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        double dx = this.m_20185_() - this.f_19790_;
        double dz = this.m_20189_() - this.f_19792_;
        double distanceTravelled = Math.sqrt(dx * dx + dz * dz);
        if (distanceTravelled > 0.2 && this.soundCooldownTicks <= 0 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundEventRegistry.CART_MOVING.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
            this.soundCooldownTicks = 45;
        }
        if (this.soundCooldownTicks > 0) {
            --this.soundCooldownTicks;
        }
        if (this.wobbleTicks > 0) {
            float wobbleAmount = (float)Math.sin((double)(10 - this.wobbleTicks) * Math.PI / 10.0) * this.wobbleDirection;
            this.m_146922_(this.m_146908_() + wobbleAmount);
            --this.wobbleTicks;
            if (this.wobbleTicks == 0) {
                this.m_146922_(this.m_146908_() - this.wobbleDirection);
            }
        }
    }

    public float getWheelRotation() {
        return this.leftWheel.getRotation();
    }

    protected double getRelativeSpacing() {
        return 2.0;
    }

    protected double getOffsetRadius() {
        return 0.0;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_213877_() || !this.m_6084_()) {
            return false;
        }
        if (source.m_7639_() instanceof Player) {
            this.setHealth(this.getHealth() - damage);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12634_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.wobbleTicks = 10;
            float f = this.wobbleDirection = this.f_19796_.m_188499_() ? 5.0f : -5.0f;
            if (this.getHealth() <= 0.0f) {
                this.destroy();
            }
            return true;
        }
        return false;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    private void destroy() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12630_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_19983_(this.getDropItem());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected ItemStack getDropItem() {
        return null;
    }
}

