/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GrandmothersRecipeBookItem
extends Item {
    private static final Map<ServerLevel, Map<UUID, Set<ResourceLocation>>> worldUnlockedRecipes = new HashMap<ServerLevel, Map<UUID, Set<ResourceLocation>>>();

    public GrandmothersRecipeBookItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41782_() && level != null) {
            CompoundTag tag = stack.m_41783_();
            ArrayList<ResourceLocation> recipeIds = new ArrayList<ResourceLocation>();
            assert (tag != null);
            if (tag.m_128441_("Recipes")) {
                tag.m_128437_("Recipes", 8).forEach(e -> recipeIds.add(new ResourceLocation(e.m_7916_())));
            } else if (tag.m_128441_("Recipe")) {
                recipeIds.add(new ResourceLocation(tag.m_128461_("Recipe")));
            }
            RecipeManager manager = level.m_7465_();
            recipeIds.forEach(id -> {
                Optional opt = manager.m_44043_(id);
                if (opt.isPresent()) {
                    ItemStack resultStack = ((Recipe)opt.get()).m_8043_(level.m_9598_());
                    tooltip.add((Component)Component.m_237113_((String)"Unlocks: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130938_(style -> style.m_178520_(16766720))).m_7220_((Component)resultStack.m_41786_().m_6881_().m_130938_(style -> style.m_178520_(16766720).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(resultStack))))).m_7220_((Component)Component.m_237113_((String)"]").m_130938_(style -> style.m_178520_(16766720))).m_7220_((Component)Component.m_237113_((String)" Recipe").m_130940_(ChatFormatting.WHITE)));
                } else {
                    tooltip.add((Component)Component.m_237113_((String)"Unlocks: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130938_(style -> style.m_178520_(16766720))).m_7220_((Component)Component.m_237113_((String)id.toString()).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"]").m_130938_(style -> style.m_178520_(16766720))).m_7220_((Component)Component.m_237113_((String)" Recipe").m_130940_(ChatFormatting.WHITE)));
                }
            });
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                ArrayList<ResourceLocation> recipeIds = new ArrayList<ResourceLocation>();
                if (tag.m_128441_("Recipes")) {
                    ListTag list = tag.m_128437_("Recipes", 8);
                    for (int i = 0; i < list.size(); ++i) {
                        recipeIds.add(new ResourceLocation(list.m_128778_(i)));
                    }
                } else if (tag.m_128441_("Recipe")) {
                    recipeIds.add(new ResourceLocation(tag.m_128461_("Recipe")));
                }
                if (!recipeIds.isEmpty()) {
                    ResourceLocation firstId;
                    ServerLevel serverLevel = (ServerLevel)serverPlayer.m_9236_();
                    Map worldMap = worldUnlockedRecipes.computeIfAbsent(serverLevel, k -> new HashMap());
                    Set unlocked = worldMap.computeIfAbsent(serverPlayer.m_20148_(), k -> new HashSet());
                    if (unlocked.contains(firstId = (ResourceLocation)recipeIds.get(0))) {
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.farm_and_charm.recipe_unlocker.already_unlocked").m_130940_(ChatFormatting.RED), false);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    RecipeManager manager = level.m_7465_();
                    ArrayList recipes = new ArrayList();
                    for (ResourceLocation id : recipeIds) {
                        Optional opt = manager.m_44043_(id);
                        opt.ifPresent(recipes::add);
                        unlocked.add(id);
                    }
                    if (!recipes.isEmpty()) {
                        Recipe firstRecipe = (Recipe)recipes.get(0);
                        ItemStack resultStack = firstRecipe.m_8043_(level.m_9598_());
                        MutableComponent message = Component.m_237115_((String)"tooltip.farm_and_charm.recipe_unlocker.unlocked.prefix").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" [").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)resultStack.m_41786_().m_6881_().m_130938_(style -> style.m_178520_(16766720).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(resultStack))))).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.WHITE));
                        serverPlayer.m_5661_((Component)message, false);
                        this.spawnLevelUpEffect(serverPlayer);
                        stack.m_41774_(1);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public static ItemStack createUnlockerForRecipes(GrandmothersRecipeBookItem item, String ... recipeIds) {
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag tag = new CompoundTag();
        if (recipeIds.length == 1) {
            tag.m_128359_("Recipe", recipeIds[0]);
        } else {
            ListTag list = new ListTag();
            for (String id : recipeIds) {
                list.add((Object)StringTag.m_129297_((String)id));
            }
            tag.m_128365_("Recipes", (Tag)list);
        }
        stack.m_41751_(tag);
        return stack;
    }

    private void spawnLevelUpEffect(final ServerPlayer player) {
        final ServerLevel level = (ServerLevel)player.m_9236_();
        final Random random = new Random();
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.2f);
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            int ticks = 0;

            @Override
            public void run() {
                if (this.ticks++ >= 30) {
                    timer.cancel();
                    return;
                }
                double angle = (double)(this.ticks * 12) * (Math.PI / 180);
                double radius = 0.6;
                double xOffset = Math.cos(angle) * radius + ((double)random.nextFloat() * 0.2 - 0.1);
                double zOffset = Math.sin(angle) * radius + ((double)random.nextFloat() * 0.2 - 0.1);
                double yOffset = (double)this.ticks * 0.04;
                level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.97f, 0.86f, 0.43f), 1.2f), player.m_20185_() + xOffset, player.m_20186_() + 0.5 + yOffset, player.m_20189_() + zOffset, 3, 0.1, 0.1, 0.1, 0.02);
                level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.54f, 1.0f, 0.54f), 1.0f), player.m_20185_() - xOffset, player.m_20186_() + 0.5 + yOffset, player.m_20189_() - zOffset, 2, 0.1, 0.1, 0.1, 0.02);
            }
        }, 0L, 60L);
    }
}

