/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CookingPotRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final boolean containerRequired;
    private final ItemStack containerItem;
    private final ItemStack output;
    private final boolean requiresLearning;

    public CookingPotRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, boolean containerRequired, ItemStack containerItem, ItemStack output, boolean requiresLearning) {
        this.id = id;
        this.inputs = inputs;
        this.containerRequired = containerRequired;
        this.containerItem = containerItem;
        this.output = output;
        this.requiresLearning = requiresLearning;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 0, 6);
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.COOKING_POT_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean isContainerRequired() {
        return this.containerRequired;
    }

    public ItemStack getContainerItem() {
        return this.containerItem;
    }

    public boolean requiresLearning() {
        return this.requiresLearning;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CookingPotRecipe> {
        @NotNull
        public CookingPotRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = GeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for CookingPot Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for CookingPot Recipe");
            }
            JsonObject containerObj = GsonHelper.m_13930_((JsonObject)json, (String)"container");
            boolean required = GsonHelper.m_13855_((JsonObject)containerObj, (String)"required", (boolean)false);
            ItemStack containerStack = ItemStack.f_41583_;
            if (required) {
                containerStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)containerObj, (String)"item"));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            boolean requiresLearning = GsonHelper.m_13855_((JsonObject)json, (String)"requiresLearning", (boolean)false);
            return new CookingPotRecipe(id, ingredients, required, containerStack, result, requiresLearning);
        }

        @NotNull
        public CookingPotRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            boolean required = buf.readBoolean();
            ItemStack containerStack = required ? buf.m_130267_() : ItemStack.f_41583_;
            ItemStack output = buf.m_130267_();
            boolean requiresLearning = buf.readBoolean();
            return new CookingPotRecipe(id, (NonNullList<Ingredient>)ingredients, required, containerStack, output, requiresLearning);
        }

        public void toNetwork(FriendlyByteBuf buf, CookingPotRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.writeBoolean(recipe.containerRequired);
            if (recipe.containerRequired) {
                buf.m_130055_(recipe.containerItem);
            }
            buf.m_130055_(recipe.output);
            buf.writeBoolean(recipe.requiresLearning);
        }
    }
}

