/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gauge;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.gauge.GaugeBlock;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;

public abstract class GaugeInstance
extends ShaftInstance<GaugeBlockEntity>
implements DynamicInstance {
    protected final ArrayList<DialFace> faces = new ArrayList(2);
    protected PoseStack ms;

    protected GaugeInstance(MaterialManager materialManager, GaugeBlockEntity blockEntity) {
        super(materialManager, blockEntity);
        GaugeBlock gaugeBlock = (GaugeBlock)this.blockState.m_60734_();
        Instancer dialModel = this.getTransformMaterial().getModel(AllPartialModels.GAUGE_DIAL, this.blockState);
        Instancer<ModelData> headModel = this.getHeadModel();
        this.ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)this.ms);
        msr.translate((Vec3i)this.getInstancePosition());
        float progress = Mth.m_14179_((float)AnimationTickHolder.getPartialTicks(), (float)blockEntity.prevDialState, (float)blockEntity.dialState);
        for (Direction facing : Iterate.directions) {
            if (!gaugeBlock.shouldRenderHeadOnFace(this.world, this.pos, this.blockState, facing)) continue;
            DialFace face = this.makeFace(facing, (Instancer<ModelData>)dialModel, headModel);
            this.faces.add(face);
            face.setupTransform(msr, progress);
        }
    }

    private DialFace makeFace(Direction face, Instancer<ModelData> dialModel, Instancer<ModelData> headModel) {
        return new DialFace(face, (ModelData)dialModel.createInstance(), (ModelData)headModel.createInstance());
    }

    public void beginFrame() {
        GaugeBlockEntity gaugeBlockEntity = (GaugeBlockEntity)this.blockEntity;
        if (Mth.m_14033_((float)gaugeBlockEntity.prevDialState, (float)gaugeBlockEntity.dialState)) {
            return;
        }
        float progress = Mth.m_14179_((float)AnimationTickHolder.getPartialTicks(), (float)gaugeBlockEntity.prevDialState, (float)gaugeBlockEntity.dialState);
        TransformStack msr = TransformStack.cast((PoseStack)this.ms);
        for (DialFace faceEntry : this.faces) {
            faceEntry.updateTransform(msr, progress);
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.faces.stream().flatMap(Couple::stream));
    }

    @Override
    public void remove() {
        super.remove();
        this.faces.forEach(DialFace::delete);
    }

    protected abstract Instancer<ModelData> getHeadModel();

    private class DialFace
    extends Couple<ModelData> {
        Direction face;

        public DialFace(Direction face, ModelData first, ModelData second) {
            super(first, second);
            this.face = face;
        }

        private void setupTransform(TransformStack msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            this.rotateToFace(msr);
            ((ModelData)this.getSecond()).setTransform(GaugeInstance.this.ms);
            ((TransformStack)((TransformStack)msr.translate(0.0, (double)dialPivot, (double)dialPivot)).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot));
            ((ModelData)this.getFirst()).setTransform(GaugeInstance.this.ms);
            msr.popPose();
        }

        private void updateTransform(TransformStack msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            ((TransformStack)((TransformStack)this.rotateToFace(msr).translate(0.0, (double)dialPivot, (double)dialPivot)).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress)))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot));
            ((ModelData)this.getFirst()).setTransform(GaugeInstance.this.ms);
            msr.popPose();
        }

        protected TransformStack rotateToFace(TransformStack msr) {
            return (TransformStack)((TransformStack)((TransformStack)msr.centre()).rotate(Direction.UP, (float)((double)((-this.face.m_122435_() - 90.0f) / 180.0f) * Math.PI))).unCentre();
        }

        private void delete() {
            ((ModelData)this.getFirst()).delete();
            ((ModelData)this.getSecond()).delete();
        }
    }

    public static class Stress
    extends GaugeInstance {
        public Stress(MaterialManager materialManager, GaugeBlockEntity blockEntity) {
            super(materialManager, blockEntity);
        }

        @Override
        protected Instancer<ModelData> getHeadModel() {
            return this.getTransformMaterial().getModel(AllPartialModels.GAUGE_HEAD_STRESS, this.blockState);
        }
    }

    public static class Speed
    extends GaugeInstance {
        public Speed(MaterialManager materialManager, GaugeBlockEntity blockEntity) {
            super(materialManager, blockEntity);
        }

        @Override
        protected Instancer<ModelData> getHeadModel() {
            return this.getTransformMaterial().getModel(AllPartialModels.GAUGE_HEAD_SPEED, this.blockState);
        }
    }
}

