/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.arithmetic.predicates;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import java.util.List;

@FunctionalInterface
public interface IotaPredicate {
    public static final IotaPredicate TRUE = iota -> true;

    public boolean test(Iota var1);

    public static IotaPredicate or(IotaPredicate left, IotaPredicate right) {
        return new Or(left, right);
    }

    public static IotaPredicate any(IotaPredicate ... any) {
        return new Any(any);
    }

    public static IotaPredicate any(List<IotaPredicate> any) {
        return new Any((IotaPredicate[])any.toArray(IotaPredicate[]::new));
    }

    public static IotaPredicate ofType(IotaType<?> type) {
        return new OfType(type);
    }

    public record Or(IotaPredicate left, IotaPredicate right) implements IotaPredicate
    {
        @Override
        public boolean test(Iota iota) {
            return this.left.test(iota) || this.right.test(iota);
        }
    }

    public record Any(IotaPredicate[] any) implements IotaPredicate
    {
        @Override
        public boolean test(Iota iota) {
            for (IotaPredicate i : this.any) {
                if (!i.test(iota)) continue;
                return true;
            }
            return false;
        }
    }

    public record OfType(IotaType<?> type) implements IotaPredicate
    {
        @Override
        public boolean test(Iota iota) {
            return iota.getType().equals(this.type);
        }
    }
}

