/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.gui;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.PatternColors;
import at.petrak.hexcasting.client.render.PatternRenderer;
import at.petrak.hexcasting.client.render.WorldlyPatternRenderHelpers;
import at.petrak.hexcasting.common.misc.PatternTooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;

public class PatternTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation PRISTINE_BG = HexAPI.modLoc("textures/gui/scroll.png");
    public static final ResourceLocation ANCIENT_BG = HexAPI.modLoc("textures/gui/scroll_ancient.png");
    public static final ResourceLocation SLATE_BG = HexAPI.modLoc("textures/gui/slate.png");
    private static final float RENDER_SIZE = 128.0f;
    private static final int TEXTURE_SIZE = 48;
    private final HexPattern pattern;
    private final ResourceLocation background;

    public PatternTooltipComponent(PatternTooltip tt) {
        this.pattern = tt.pattern();
        this.background = tt.background();
    }

    @Nullable
    public static ClientTooltipComponent tryConvert(TooltipComponent cmp) {
        if (cmp instanceof PatternTooltip) {
            PatternTooltip ptt = (PatternTooltip)cmp;
            return new PatternTooltipComponent(ptt);
        }
        return null;
    }

    public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics graphics) {
        PoseStack ps = graphics.m_280168_();
        ps.m_85836_();
        ps.m_252880_((float)mouseX, (float)mouseY, 500.0f);
        RenderSystem.enableBlend();
        PatternTooltipComponent.renderBG(graphics, this.background);
        ps.m_252880_(0.0f, 0.0f, 100.0f);
        ps.m_85841_(128.0f, 128.0f, 1.0f);
        PatternRenderer.renderPattern(this.pattern, ps, WorldlyPatternRenderHelpers.READABLE_SCROLL_SETTINGS, (PatternRenderer.shouldDoStrokeGradient() ? PatternColors.DEFAULT_GRADIENT_COLOR : PatternColors.DEFAULT_PATTERN_COLOR).withDots(true, true), 0.0, 512);
        ps.m_85849_();
    }

    private static void renderBG(GuiGraphics graphics, ResourceLocation background) {
        graphics.m_280411_(background, 0, 0, 128, 128, 0.0f, 0.0f, 48, 48, 48, 48);
    }

    public int m_142069_(Font pFont) {
        return 128;
    }

    public int m_142103_() {
        return 128;
    }
}

