/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpColorize;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpColorize
implements SpellAction {
    @NotNull
    public static final OpColorize INSTANCE = new OpColorize();
    private static final int argc;

    private OpColorize() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        CastingEnvironment.HeldItemInfo heldItemInfo = env.getHeldItemToOperateOn(IXplatAbstractions.INSTANCE::isPigment);
        if (heldItemInfo == null) {
            throw MishapBadOffhandItem.Companion.of(ItemStack.f_41583_, "colorizer", new Object[0]);
        }
        ItemStack handStack = heldItemInfo.component1();
        if (!IXplatAbstractions.INSTANCE.isPigment(handStack)) {
            throw MishapBadOffhandItem.Companion.of(handStack, "colorizer", new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)handStack, (String)"handStack");
        return new SpellAction.Result(new Spell(handStack), 10000L, CollectionsKt.emptyList(), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpColorize$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;)V", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final ItemStack stack;

        public Spell(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.stack = stack;
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            ItemStack copy = this.stack.m_41777_();
            if (env.withdrawItem(arg_0 -> Spell.cast$lambda$0(copy, arg_0), 1, true)) {
                Object object = env.getCastingEntity();
                if (object == null || (object = object.m_20148_()) == null) {
                    object = Util.f_137441_;
                }
                env.setPigment(new FrozenPigment(copy, (UUID)object));
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final ItemStack component1() {
            return this.stack;
        }

        @NotNull
        public final Spell copy(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new Spell(stack);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, ItemStack itemStack, int n, Object object) {
            if ((n & 1) != 0) {
                itemStack = spell.stack;
            }
            return spell.copy(itemStack);
        }

        @NotNull
        public String toString() {
            return "Spell(stack=" + this.stack + ")";
        }

        public int hashCode() {
            return this.stack.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual((Object)this.stack, (Object)spell.stack);
        }

        private static final boolean cast$lambda$0(ItemStack $copy, ItemStack it) {
            return ItemStack.m_150942_((ItemStack)$copy, (ItemStack)it);
        }
    }
}

