/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StateIngredientBlocks
implements StateIngredient {
    protected final ImmutableSet<Block> blocks;

    public StateIngredientBlocks(Collection<Block> blocks) {
        this.blocks = ImmutableSet.copyOf(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains((Object)state.m_60734_());
    }

    @Override
    public BlockState pick(Random random) {
        return ((Block)this.blocks.asList().get(random.nextInt(this.blocks.size()))).m_49966_();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "blocks");
        JsonArray array = new JsonArray();
        for (Block block : this.blocks) {
            array.add(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
        }
        object.add("blocks", (JsonElement)array);
        return object;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        List<Block> blocks = this.getBlocks();
        buffer.m_130130_(0);
        buffer.m_130130_(blocks.size());
        for (Block block : blocks) {
            buffer.m_130130_(BuiltInRegistries.f_256975_.m_7447_((Object)block));
        }
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.blocks.stream().filter(b -> b.m_5456_() != Items.f_41852_).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.blocks.stream().map(Block::m_49966_).collect(Collectors.toList());
    }

    @Nonnull
    protected List<Block> getBlocks() {
        return this.blocks.asList();
    }

    public String toString() {
        return "StateIngredientBlocks{" + this.blocks.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.blocks.equals(((StateIngredientBlocks)o).blocks);
    }

    public int hashCode() {
        return Objects.hash(this.blocks);
    }
}

