/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.network;

import corgitaco.blockswap.network.packet.ClientConfigSyncPacket;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("blockswap", "config_network"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        SIMPLE_CHANNEL.registerMessage(0, ClientConfigSyncPacket.class, ClientConfigSyncPacket::writeToPacket, ClientConfigSyncPacket::readFromPacket, NetworkHandler::handle);
    }

    public static void handle(ClientConfigSyncPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(message::handle);
        }
        ctx.get().setPacketHandled(true);
    }

    public static void sendToClient(ServerPlayer playerEntity, Object objectToSend) {
        SIMPLE_CHANNEL.sendTo(objectToSend, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object objectToSend) {
        SIMPLE_CHANNEL.sendToServer(objectToSend);
    }
}

