/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.util.jankson;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import corgitaco.blockswap.BlockSwap;
import corgitaco.blockswap.shadow.blue.endless.jankson.Jankson;
import corgitaco.blockswap.shadow.blue.endless.jankson.JsonArray;
import corgitaco.blockswap.shadow.blue.endless.jankson.JsonElement;
import corgitaco.blockswap.shadow.blue.endless.jankson.JsonGrammar;
import corgitaco.blockswap.shadow.blue.endless.jankson.JsonObject;
import corgitaco.blockswap.shadow.blue.endless.jankson.api.SyntaxError;
import corgitaco.blockswap.util.jankson.JsonArrayOfArrays;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;

public class JanksonUtil {
    public static RuntimeException thrown = null;
    public static final String HEADER_OPEN = "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.";
    public static final String HEADER_CLOSED = "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/";
    public static final Jankson JANKSON = Jankson.builder().allowBareRootObject().build();
    public static final Supplier<JsonGrammar.Builder> JSON_GRAMMAR_BUILDER = () -> new JsonGrammar.Builder().withComments(true).bareSpecialNumerics(true).printCommas(true);
    public static final JsonGrammar JSON_GRAMMAR = JSON_GRAMMAR_BUILDER.get().build();

    public static JsonObject addCommentsAndAlphabeticallySortRecursively(Map<String, String> comments, JsonObject object, String parentKey, boolean alphabeticallySorted) {
        for (Map.Entry<String, JsonElement> entry2 : object.entrySet()) {
            JsonElement value;
            String objectKey = entry2.getKey();
            String commentsKey = parentKey + objectKey;
            String comment = object.getComment(entry2.getKey());
            if (comments.containsKey(commentsKey) && comment == null) {
                String commentToAdd = comments.get(commentsKey);
                object.setComment(objectKey, commentToAdd);
                comment = commentToAdd;
            }
            if ((value = entry2.getValue()) instanceof JsonArray) {
                JsonArray array = (JsonArray)value;
                JsonArray sortedJsonElements = new JsonArray();
                for (JsonElement element : array) {
                    if (element instanceof JsonObject) {
                        JsonObject nestedObject = (JsonObject)element;
                        sortedJsonElements.add(JanksonUtil.addCommentsAndAlphabeticallySortRecursively(comments, nestedObject, entry2.getKey() + ".", alphabeticallySorted));
                        continue;
                    }
                    if (!(element instanceof JsonArray)) continue;
                    JsonArray array1 = (JsonArray)element;
                    JsonArrayOfArrays arrayOfArrays = new JsonArrayOfArrays();
                    arrayOfArrays.addAll(array1);
                    sortedJsonElements.add(arrayOfArrays);
                }
                if (!sortedJsonElements.isEmpty()) {
                    object.put(objectKey, sortedJsonElements, comment);
                }
            }
            if (!(value instanceof JsonObject)) continue;
            JsonObject nestedObject = (JsonObject)value;
            object.put(objectKey, JanksonUtil.addCommentsAndAlphabeticallySortRecursively(comments, nestedObject, entry2.getKey() + ".", alphabeticallySorted), comment);
        }
        if (alphabeticallySorted) {
            JsonObject alphabeticallySortedJsonObject = new JsonObject();
            TreeMap<String, JsonElement> map = new TreeMap<String, JsonElement>(String::compareTo);
            map.putAll(object);
            alphabeticallySortedJsonObject.putAll((Map<? extends String, ? extends JsonElement>)map);
            alphabeticallySortedJsonObject.forEach((key, entry) -> alphabeticallySortedJsonObject.setComment((String)key, object.getComment((String)key)));
            return alphabeticallySortedJsonObject;
        }
        return object;
    }

    public static <T> void createConfig(Path path, Codec<T> codec, String header, Map<String, String> comments, DynamicOps<JsonElement> ops, T from) {
        DataResult dataResult = codec.encodeStart(ops, from);
        Optional error = dataResult.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException(String.format("Jankson file creation for \"%s\" failed due to the following error(s):\n%s", path.toString(), ((DataResult.PartialResult)error.get()).message()));
        }
        JsonElement jsonElement = (JsonElement)dataResult.result().orElseThrow();
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonElement = JanksonUtil.addCommentsAndAlphabeticallySortRecursively(comments, jsonObject, "", true);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String output = header + "\n" + jsonElement.toJson(JSON_GRAMMAR);
            Files.write(path, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BlockSwap.LOGGER.error(e.toString());
        }
    }

    public static <T> T readConfig(Path path, Codec<T> codec, DynamicOps<JsonElement> ops) throws IOException, SyntaxError {
        JsonElement load = null;
        try {
            load = JANKSON.loadElement(path.toFile());
            DataResult decode = codec.decode(ops, (Object)load);
            Optional error = decode.error();
            if (error.isPresent()) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Jankson file reading for \"%s\" failed due to the following error(s):\n%s\n\nConfig:\n\n%s\n%s\n%s\nAs JSON LOADED ELEMENT:\n%s\n%s", path, ((DataResult.PartialResult)error.get()).message(), "=".repeat(100), JanksonUtil.configStringFromBytes(path), "=".repeat(100), load.toJson(JSON_GRAMMAR), "=".repeat(100)));
                thrown = illegalArgumentException;
                throw illegalArgumentException;
            }
            return (T)((Pair)decode.result().orElseThrow()).getFirst();
        }
        catch (Exception errorMsg) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Jankson file reading for \"%s\" failed due to the following error(s):\n%s\n\nConfig:\n\n%s\n%s\n%s\nAs JSON LOADED ELEMENT:\n%s\n%s", path, errorMsg, "=".repeat(100), JanksonUtil.configStringFromBytes(path), "=".repeat(100), load == null ? "NOT AVAILABLE BECAUSE JSONELEMENT WAS NULL" : load.toJson(JSON_GRAMMAR), "=".repeat(100)));
            thrown = illegalArgumentException;
            throw illegalArgumentException;
        }
    }

    private static String configStringFromBytes(Path path) {
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return String.format("Unable to read file bytes \"%s\" due to error(s):\n%s", path, e);
        }
    }
}

