/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.model;

import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.blocks.matrix.BlockAssemblerMatrixGlass;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AssemblerGlassBakedModel
implements IDynamicBakedModel {
    private static final ChunkRenderTypeSet RENDER_TYPES = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    private static final Object2ReferenceMap<FaceCorner, List<Vector3f>> V_MAP = AssemblerGlassBakedModel.createVertexMap();
    private static final EnumMap<Direction, List<Vector3f>> F_MAP = AssemblerGlassBakedModel.createFaceMap();
    public static final ModelProperty<Connect> CONNECT_STATE = new ModelProperty();
    private static final int LU = 0;
    private static final int RU = 1;
    private static final int LD = 2;
    private static final int RD = 4;
    private static final Material SIDE = new Material(InventoryMenu.f_39692_, ExtendedAE.id("block/assembler_matrix/glass/sides"));
    private static final Material[] FACES = new Material[]{new Material(InventoryMenu.f_39692_, ExtendedAE.id("block/assembler_matrix/glass/face_a")), new Material(InventoryMenu.f_39692_, ExtendedAE.id("block/assembler_matrix/glass/face_b")), new Material(InventoryMenu.f_39692_, ExtendedAE.id("block/assembler_matrix/glass/face_c"))};
    private final TextureAtlasSprite glassSide;
    private final TextureAtlasSprite[] glassFaces;

    public AssemblerGlassBakedModel(Function<Material, TextureAtlasSprite> getter) {
        this.glassSide = getter.apply(SIDE);
        this.glassFaces = (TextureAtlasSprite[])Arrays.stream(FACES).map(getter).toArray(TextureAtlasSprite[]::new);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        Connect connect = new Connect();
        connect.init(pos);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset = pos.m_7918_(x, y, z);
                    if (!(world.m_8055_(offset).getAppearance(world, offset, Direction.NORTH, state, pos).m_60734_() instanceof BlockAssemblerMatrixGlass)) continue;
                    connect.set(x, y, z);
                }
            }
        }
        return modelData.derive().with(CONNECT_STATE, (Object)connect).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, @NotNull RandomSource randomSource, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (side == null) {
            return Collections.emptyList();
        }
        Connect connect = (Connect)modelData.get(CONNECT_STATE);
        if (connect == null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.addQuad(quads, side, connect.getIndex(side, 0), 0);
        this.addQuad(quads, side, connect.getIndex(side, 1), 1);
        this.addQuad(quads, side, connect.getIndex(side, 2), 2);
        this.addQuad(quads, side, connect.getIndex(side, 4), 4);
        this.addQuad(quads, side, connect.getFace(side));
        return quads;
    }

    private List<Vector3f> calculateCorners(Direction face, int corner) {
        return (List)V_MAP.get((Object)new FaceCorner(face, corner));
    }

    private void addQuad(List<BakedQuad> quads, Direction side, int index) {
        if (index < 0) {
            return;
        }
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(quads::add);
        TextureAtlasSprite sprite = this.glassFaces[index];
        List<Vector3f> cons = F_MAP.get(side);
        builder.setSprite(sprite);
        builder.setDirection(side);
        Vec3i normal = side.m_122436_();
        Vector3f c1 = cons.get(0);
        Vector3f c2 = cons.get(1);
        Vector3f c3 = cons.get(2);
        Vector3f c4 = cons.get(3);
        this.putVertex(builder, sprite, normal, c1.x(), c1.y(), c1.z(), 0.0f, 0.0f);
        this.putVertex(builder, sprite, normal, c2.x(), c2.y(), c2.z(), 0.0f, 16.0f);
        this.putVertex(builder, sprite, normal, c3.x(), c3.y(), c3.z(), 16.0f, 16.0f);
        this.putVertex(builder, sprite, normal, c4.x(), c4.y(), c4.z(), 16.0f, 0.0f);
    }

    private void addQuad(List<BakedQuad> quads, Direction side, int index, int corner) {
        if (index < 0) {
            return;
        }
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(quads::add);
        List<Vector3f> cons = this.calculateCorners(side, corner);
        builder.setSprite(this.glassSide);
        builder.setDirection(side);
        Vec3i normal = side.m_122436_();
        Vector3f c1 = cons.get(0);
        Vector3f c2 = cons.get(1);
        Vector3f c3 = cons.get(2);
        Vector3f c4 = cons.get(3);
        float u0 = this.getU0(index);
        float u1 = this.getU1(index);
        float v0 = this.getV0(index);
        float v1 = this.getV1(index);
        switch (corner) {
            case 0: {
                this.putVertex(builder, this.glassSide, normal, c1.x(), c1.y(), c1.z(), u0, v0);
                this.putVertex(builder, this.glassSide, normal, c2.x(), c2.y(), c2.z(), u0, v1);
                this.putVertex(builder, this.glassSide, normal, c3.x(), c3.y(), c3.z(), u1, v1);
                this.putVertex(builder, this.glassSide, normal, c4.x(), c4.y(), c4.z(), u1, v0);
                break;
            }
            case 1: {
                this.putVertex(builder, this.glassSide, normal, c1.x(), c1.y(), c1.z(), u1, v0);
                this.putVertex(builder, this.glassSide, normal, c2.x(), c2.y(), c2.z(), u1, v1);
                this.putVertex(builder, this.glassSide, normal, c3.x(), c3.y(), c3.z(), u0, v1);
                this.putVertex(builder, this.glassSide, normal, c4.x(), c4.y(), c4.z(), u0, v0);
                break;
            }
            case 2: {
                this.putVertex(builder, this.glassSide, normal, c1.x(), c1.y(), c1.z(), u0, v1);
                this.putVertex(builder, this.glassSide, normal, c2.x(), c2.y(), c2.z(), u0, v0);
                this.putVertex(builder, this.glassSide, normal, c3.x(), c3.y(), c3.z(), u1, v0);
                this.putVertex(builder, this.glassSide, normal, c4.x(), c4.y(), c4.z(), u1, v1);
                break;
            }
            case 4: {
                this.putVertex(builder, this.glassSide, normal, c1.x(), c1.y(), c1.z(), u1, v1);
                this.putVertex(builder, this.glassSide, normal, c2.x(), c2.y(), c2.z(), u1, v0);
                this.putVertex(builder, this.glassSide, normal, c3.x(), c3.y(), c3.z(), u0, v0);
                this.putVertex(builder, this.glassSide, normal, c4.x(), c4.y(), c4.z(), u0, v1);
            }
        }
    }

    private static EnumMap<Direction, List<Vector3f>> createFaceMap() {
        EnumMap<Direction, List<Vector3f>> map = new EnumMap<Direction, List<Vector3f>>(Direction.class);
        map.put(Direction.EAST, List.of(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)));
        map.put(Direction.WEST, Lists.reverse(List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f))));
        map.put(Direction.UP, List.of(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f)));
        map.put(Direction.DOWN, Lists.reverse(List.of(new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f))));
        map.put(Direction.SOUTH, List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
        map.put(Direction.NORTH, Lists.reverse(List.of(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f))));
        return map;
    }

    private static Object2ReferenceMap<FaceCorner, List<Vector3f>> createVertexMap() {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)new FaceCorner(Direction.EAST, 0), List.of(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(1.0f, 0.5f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.EAST, 1), List.of(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 0.5f, 0.5f), new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.EAST, 2), List.of(new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.5f), new Vector3f(1.0f, 0.5f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.EAST, 4), List.of(new Vector3f(1.0f, 0.5f, 0.5f), new Vector3f(1.0f, 0.0f, 0.5f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.WEST, 0), List.of(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.WEST, 1), List.of(new Vector3f(0.0f, 1.0f, 0.5f), new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 0.5f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.WEST, 2), List.of(new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.0f, 0.5f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.WEST, 4), List.of(new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.5f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 0), List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.5f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f), new Vector3f(0.5f, 1.0f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 1), List.of(new Vector3f(0.5f, 1.0f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f), new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 2), List.of(new Vector3f(0.0f, 0.5f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 4), List.of(new Vector3f(0.5f, 0.5f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.5f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 0), List.of(new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 1), List.of(new Vector3f(0.5f, 1.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 2), List.of(new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 4), List.of(new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.UP, 0), List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.5f, 1.0f, 1.0f), new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(0.0f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.UP, 1), List.of(new Vector3f(0.0f, 1.0f, 0.5f), new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(0.5f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.UP, 2), List.of(new Vector3f(0.5f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(0.5f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.UP, 4), List.of(new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 0), List.of(new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 0.5f), new Vector3f(1.0f, 0.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 1), List.of(new Vector3f(1.0f, 0.0f, 0.5f), new Vector3f(0.5f, 0.0f, 0.5f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 2), List.of(new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.5f, 0.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 4), List.of(new Vector3f(0.5f, 0.0f, 0.5f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f)));
        return map;
    }

    private void putVertex(QuadBakingVertexConsumer builder, TextureAtlasSprite sprite, Vec3i normal, float x, float y, float z, float u, float v) {
        builder.m_5483_((double)x, (double)y, (double)z);
        builder.m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
        builder.m_5601_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
        u = sprite.m_118367_((double)u);
        v = sprite.m_118393_((double)v);
        builder.m_7421_(u, v);
        builder.m_5752_();
    }

    private float getU0(int index) {
        return switch (index) {
            case 1, 3 -> 8.0f;
            default -> 0.0f;
        };
    }

    private float getU1(int index) {
        return switch (index) {
            case 1, 3 -> 16.0f;
            default -> 8.0f;
        };
    }

    private float getV0(int index) {
        return switch (index) {
            case 2, 3 -> 8.0f;
            default -> 0.0f;
        };
    }

    private float getV1(int index) {
        return switch (index) {
            case 2, 3 -> 16.0f;
            default -> 8.0f;
        };
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.glassSide;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return RENDER_TYPES;
    }

    public static class Connect {
        private final boolean[][][] connects = new boolean[3][3][3];
        private int face;

        int getFace(Direction face) {
            if (!this.validCheck(face)) {
                return -1;
            }
            return this.face;
        }

        void init(BlockPos pos) {
            this.face = Math.abs((pos.m_123341_() ^ pos.m_123342_() ^ pos.m_123343_()) % 3);
        }

        void set(int x, int y, int z) {
            this.connects[x + 1][y + 1][z + 1] = true;
        }

        int getIndex(Direction face, int corner) {
            if (!this.validCheck(face)) {
                return -1;
            }
            return switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.WEST, Direction.EAST -> this.getIndexX(face, corner);
                case Direction.DOWN, Direction.UP -> this.getIndexY(face, corner);
                case Direction.NORTH, Direction.SOUTH -> this.getIndexZ(face, corner);
            };
        }

        boolean validCheck(Direction face) {
            Vec3i pos = face.m_122436_().m_7918_(1, 1, 1);
            return !this.connects[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()];
        }

        int getIndexX(Direction face, int corner) {
            int x = face.m_122429_();
            return switch (corner) {
                case 0 -> this.getIndex(this.connects[1][1][1 + x], this.connects[1][2][1], this.connects[1][2][1 + x]);
                case 1 -> this.getIndex(this.connects[1][1][1 - x], this.connects[1][2][1], this.connects[1][2][1 - x]);
                case 2 -> this.getIndex(this.connects[1][1][1 + x], this.connects[1][0][1], this.connects[1][0][1 + x]);
                case 4 -> this.getIndex(this.connects[1][1][1 - x], this.connects[1][0][1], this.connects[1][0][1 - x]);
                default -> -1;
            };
        }

        int getIndexZ(Direction face, int corner) {
            int z = face.m_122431_();
            return switch (corner) {
                case 0 -> this.getIndex(this.connects[1 - z][1][1], this.connects[1][2][1], this.connects[1 - z][2][1]);
                case 1 -> this.getIndex(this.connects[1 + z][1][1], this.connects[1][2][1], this.connects[1 + z][2][1]);
                case 2 -> this.getIndex(this.connects[1 - z][1][1], this.connects[1][0][1], this.connects[1 - z][0][1]);
                case 4 -> this.getIndex(this.connects[1 + z][1][1], this.connects[1][0][1], this.connects[1 + z][0][1]);
                default -> -1;
            };
        }

        int getIndexY(Direction face, int corner) {
            int y = face.m_122430_();
            return switch (corner) {
                case 0 -> this.getIndex(this.connects[1][1][2], this.connects[1 - y][1][1], this.connects[1 - y][1][2]);
                case 1 -> this.getIndex(this.connects[1][1][0], this.connects[1 - y][1][1], this.connects[1 - y][1][0]);
                case 2 -> this.getIndex(this.connects[1][1][2], this.connects[1 + y][1][1], this.connects[1 + y][1][2]);
                case 4 -> this.getIndex(this.connects[1][1][0], this.connects[1 + y][1][1], this.connects[1 + y][1][0]);
                default -> -1;
            };
        }

        int getIndex(boolean a, boolean b, boolean c) {
            if (!a && !b) {
                return 0;
            }
            if (a && b && !c) {
                return 1;
            }
            if (!a && b) {
                return 2;
            }
            if (a && !b) {
                return 3;
            }
            return -1;
        }
    }

    private record FaceCorner(Direction face, int corner) {
    }
}

