/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util.recipe;

import com.glodblock.github.extendedae.util.RecipeManagerAccessor;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeSearchContext<C extends Container, T extends Recipe<C>> {
    public boolean stuck;
    public boolean dirty;
    @Nullable
    public T lastRecipe;
    @Nullable
    public T currentRecipe;
    private final Supplier<Level> levelGetter;
    private final RecipeType<T> type;

    public RecipeSearchContext(Supplier<Level> levelGetter, RecipeType<T> type) {
        this.levelGetter = levelGetter;
        this.type = type;
    }

    public void findRecipe() {
        if (this.lastRecipe != null) {
            if (this.testRecipe(this.lastRecipe)) {
                this.currentRecipe = this.lastRecipe;
                this.stuck = false;
                return;
            }
            this.lastRecipe = null;
        }
        this.stuck = false;
        this.onFind(this.searchRecipe());
    }

    public void onInvChange() {
        this.stuck = false;
        this.dirty = true;
    }

    public boolean shouldTick() {
        if (this.currentRecipe != null) {
            return true;
        }
        return !this.stuck;
    }

    public void onFind(@Nullable T recipe) {
        if (recipe == null) {
            if (this.dirty) {
                this.dirty = false;
                return;
            }
            this.stuck = true;
            this.currentRecipe = null;
            return;
        }
        this.dirty = false;
        this.lastRecipe = recipe;
        this.currentRecipe = recipe;
        this.stuck = false;
    }

    public T searchRecipe() {
        Level level = this.levelGetter.get();
        if (level == null) {
            return null;
        }
        Map<ResourceLocation, T> recipes = this.getRecipeMap(level);
        for (Recipe recipe : recipes.values()) {
            if (!this.testRecipe(recipe)) continue;
            return (T)recipe;
        }
        return null;
    }

    public abstract boolean testRecipe(T var1);

    public abstract void runRecipe(T var1);

    public void save(CompoundTag tag) {
        CompoundTag nbt = new CompoundTag();
        if (this.currentRecipe != null) {
            nbt.m_128359_("current", this.currentRecipe.m_6423_().toString());
        }
        if (this.lastRecipe != null) {
            nbt.m_128359_("last", this.lastRecipe.m_6423_().toString());
        }
        tag.m_128365_("recipeCtx", (Tag)nbt);
    }

    public void load(CompoundTag tag) {
        ResourceLocation id;
        Level level = this.levelGetter.get();
        if (level == null) {
            return;
        }
        CompoundTag nbt = tag.m_128469_("recipeCtx");
        if (nbt.m_128441_("current")) {
            try {
                id = new ResourceLocation(tag.m_128461_("current"));
                this.currentRecipe = (Recipe)this.getRecipeMap(level).get(id);
            }
            catch (Throwable e) {
                this.currentRecipe = null;
            }
        }
        if (nbt.m_128441_("last")) {
            try {
                id = new ResourceLocation(tag.m_128461_("last"));
                this.lastRecipe = (Recipe)this.getRecipeMap(level).get(id);
            }
            catch (Throwable e) {
                this.lastRecipe = null;
            }
        }
    }

    private Map<ResourceLocation, T> getRecipeMap(Level world) {
        return ((RecipeManagerAccessor)world.m_7465_()).getByType(this.type);
    }
}

