/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.propellant;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class PrimedPropellant
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(PrimedPropellant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockState> DATA_APPEARANCE = SynchedEntityData.m_135353_(PrimedPropellant.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    protected float explosionPower = 4.0f;
    protected float fuze;

    public PrimedPropellant(EntityType<? extends PrimedPropellant> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
    }

    public static PrimedPropellant create(Level level, double x, double y, double z, BlockState blockState) {
        PrimedPropellant propellant = new PrimedPropellant((EntityType<? extends PrimedPropellant>)((EntityType)CBCEntityTypes.PRIMED_PROPELLANT.get()), level);
        propellant.m_6034_(x, y, z);
        double d = level.f_46441_.m_188500_() * 6.2831854820251465;
        propellant.m_20334_(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        propellant.setFuse(level.f_46441_.m_188503_(10) + 5);
        propellant.setAppearance(blockState);
        propellant.f_19854_ = x;
        propellant.f_19855_ = y;
        propellant.f_19856_ = z;
        return propellant;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)20);
        this.f_19804_.m_135372_(DATA_APPEARANCE, (Object)CBCBlocks.POWDER_CHARGE.getDefaultState());
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.explosionPower, ((CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get())).explosiveInteraction());
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128376_("Fuse", (short)this.getFuse());
        tag.m_128365_("Appearance", (Tag)NbtUtils.m_129202_((BlockState)this.getAppearance()));
        tag.m_128350_("ExplosionPower", this.explosionPower);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setFuse(tag.m_128448_("Fuse"));
        this.setAppearance(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(CBCRegistryUtils.getBlockRegistryKey()), (CompoundTag)tag.m_128469_("Appearance")));
        this.explosionPower = tag.m_128457_("ExplosionPower");
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.15f;
    }

    public void setFuse(int life) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)life);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public void setAppearance(BlockState state) {
        this.f_19804_.m_135381_(DATA_APPEARANCE, (Object)state);
    }

    public BlockState getAppearance() {
        return (BlockState)this.f_19804_.m_135370_(DATA_APPEARANCE);
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }
}

