/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.monitor.MonitorBlock;
import com.happysg.radar.block.monitor.MonitorFilter;
import com.happysg.radar.block.radar.bearing.RadarBearingBlockEntity;
import com.happysg.radar.block.radar.bearing.RadarTrack;
import com.happysg.radar.block.radar.bearing.VSRadarTracks;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MonitorBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation {
    public static final int MAX_RADIUS = 5;
    protected BlockPos controller;
    protected int radius = 1;
    private int ticksSinceLastUpdate = 0;
    protected BlockPos radarPos;
    RadarBearingBlockEntity radar;
    protected String hoveredEntity;
    protected String selectedEntity;
    MonitorFilter filter = MonitorFilter.ALL_ENTITIES;

    public MonitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public BlockPos getControllerPos() {
        if (this.controller == null) {
            return this.m_58899_();
        }
        return this.controller;
    }

    public int getSize() {
        return this.radius;
    }

    public void tick() {
        super.tick();
        if (this.ticksSinceLastUpdate > 60) {
            this.setRadarPos(null);
        }
        ++this.ticksSinceLastUpdate;
    }

    public void setControllerPos(BlockPos pPos, int size) {
        this.controller = pPos;
        this.radius = size;
        this.notifyUpdate();
    }

    public void setRadarPos(BlockPos pPos) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.getControllerPos());
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            if (pPos == null) {
                this.radarPos = null;
                this.radar = null;
                this.notifyUpdate();
                return;
            }
            monitor.radarPos = pPos;
            monitor.ticksSinceLastUpdate = 0;
            monitor.notifyUpdate();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        this.controller = null;
        this.radarPos = null;
        this.radar = null;
        super.read(tag, clientPacket);
        if (tag.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Controller"));
        }
        if (tag.m_128441_("radarPos")) {
            this.radarPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("radarPos"));
        }
        if (tag.m_128441_("SelectedEntity")) {
            this.selectedEntity = tag.m_128461_("SelectedEntity");
        }
        this.filter = MonitorFilter.values()[tag.m_128451_("Filter")];
        this.radius = tag.m_128451_("Size");
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.controller != null) {
            tag.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.radarPos != null) {
            tag.m_128365_("radarPos", (Tag)NbtUtils.m_129224_((BlockPos)this.radarPos));
        }
        if (this.selectedEntity != null) {
            tag.m_128359_("SelectedEntity", this.selectedEntity);
        }
        tag.m_128405_("Filter", this.filter.ordinal());
        tag.m_128405_("Size", this.radius);
    }

    public boolean isController() {
        return this.m_58899_().equals((Object)this.controller) || this.controller == null;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(5.0);
    }

    public Optional<RadarBearingBlockEntity> getRadar() {
        if (this.radar != null) {
            return Optional.of(this.radar);
        }
        if (this.radarPos == null) {
            return Optional.empty();
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.radarPos);
        if (blockEntity instanceof RadarBearingBlockEntity) {
            RadarBearingBlockEntity radar;
            this.radar = radar = (RadarBearingBlockEntity)blockEntity;
        }
        return Optional.ofNullable(this.radar);
    }

    public AABB getMultiblockBounds(LevelAccessor level, BlockPos pos) {
        if (this.getControllerPos() == null) {
            return new AABB(pos);
        }
        if (!level.m_8055_(this.getControllerPos()).m_61138_((Property)MonitorBlock.f_54117_)) {
            return new AABB(pos);
        }
        Direction facing = ((Direction)level.m_8055_(this.getControllerPos()).m_61143_((Property)MonitorBlock.f_54117_)).m_122427_();
        VoxelShape shape = level.m_8055_(this.getControllerPos()).m_60808_((BlockGetter)level, this.getControllerPos());
        return shape.m_83215_().m_82338_(this.getControllerPos()).m_82363_((double)(facing.m_122429_() * (this.radius - 1)), (double)(this.radius - 1), (double)(facing.m_122431_() * (this.radius - 1)));
    }

    public InteractionResult onUse(Player pPlayer, InteractionHand pHand, BlockHitResult pHit, Direction facing) {
        Vec3 selected = pPlayer.m_19907_(5.0, 0.0f, false).m_82450_();
        if (pPlayer.m_6144_()) {
            this.selectedEntity = null;
        } else {
            this.setSelectedEntity(pHit.m_82450_(), facing);
        }
        return InteractionResult.SUCCESS;
    }

    private void setSelectedEntity(Vec3 location, Direction monitorFacing) {
        float sizeadj;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.radarPos == null) {
            return;
        }
        Direction facing = ((Direction)this.f_58857_.m_8055_(this.getControllerPos()).m_61143_((Property)MonitorBlock.f_54117_)).m_122427_();
        int size = this.getSize();
        Vec3 center = Vec3.m_82512_((Vec3i)this.getControllerPos()).m_82520_((double)(facing.m_122429_() * (size - 1)) / 2.0, (double)(size - 1) / 2.0, (double)(facing.m_122431_() * (size - 1)) / 2.0);
        Vec3 relative = location.m_82546_(center);
        relative = this.adjustRelativeVectorForFacing(relative, monitorFacing);
        Vec3 RadarPos = this.radarPos.m_252807_();
        float range = this.getRadar().map(RadarBearingBlockEntity::getRange).orElse(Float.valueOf(0.0f)).floatValue();
        float f = sizeadj = size == 1 ? 0.5f : (float)(size - 1) / 2.0f;
        if (size == 2) {
            sizeadj = 0.75f;
        }
        Vec3 selected = RadarPos.m_82549_(relative.m_82490_((double)(range / sizeadj)));
        this.getRadar().ifPresent(radar -> {
            double newDistance;
            Vec3 selectedNew;
            Vec3 entityPos;
            double bestDistance = 0.1f * range;
            for (RadarTrack radarTrack : radar.getEntityPositions()) {
                entityPos = radarTrack.position();
                newDistance = (entityPos = entityPos.m_82542_(1.0, 0.0, 1.0)).m_82554_(selectedNew = selected.m_82542_(1.0, 0.0, 1.0));
                if (!(newDistance < bestDistance)) continue;
                bestDistance = newDistance;
                this.selectedEntity = radarTrack.entityId();
            }
            for (VSRadarTracks vSRadarTracks : radar.getVS2Positions()) {
                entityPos = vSRadarTracks.position();
                newDistance = (entityPos = entityPos.m_82542_(1.0, 0.0, 1.0)).m_82554_(selectedNew = selected.m_82542_(1.0, 0.0, 1.0));
                if (!(newDistance < bestDistance)) continue;
                bestDistance = newDistance;
                this.selectedEntity = vSRadarTracks.id();
            }
        });
        this.notifyUpdate();
    }

    Vec3 adjustRelativeVectorForFacing(Vec3 relative, Direction monitorFacing) {
        switch (monitorFacing) {
            case NORTH: {
                return new Vec3(relative.m_7096_(), 0.0, relative.m_7098_());
            }
            case SOUTH: {
                return new Vec3(relative.m_7096_(), 0.0, -relative.m_7098_());
            }
            case WEST: {
                return new Vec3(relative.m_7098_(), 0.0, relative.m_7094_());
            }
            case EAST: {
                return new Vec3(-relative.m_7098_(), 0.0, relative.m_7094_());
            }
        }
        return relative;
    }

    public MonitorBlockEntity getController() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity controller = (MonitorBlockEntity)blockEntity;
            return controller;
        }
        return null;
    }

    public Vec3 getTargetPos() {
        return this.selectedEntity == null ? null : this.getRadar().map(radar -> radar.getEntityPositions().stream().filter(track -> track.entityId().equals(this.selectedEntity)).map(RadarTrack::position).findFirst().orElse(null)).orElse(this.getRadar().map(radar -> radar.getVS2Positions().stream().filter(track -> track.id().equals(this.selectedEntity)).map(VSRadarTracks::position).findFirst().orElse(null)).orElse(null));
    }

    public void setFilter(MonitorFilter filter) {
        this.filter = filter;
    }
}

