/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.monitor.MonitorBlock;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.monitor.MonitorSprite;
import com.happysg.radar.block.radar.bearing.RadarBearingBlockEntity;
import com.happysg.radar.block.radar.bearing.RadarTrack;
import com.happysg.radar.block.radar.bearing.VSRadarTracks;
import com.happysg.radar.compat.vs2.VS2Utils;
import com.happysg.radar.registry.ModRenderTypes;
import com.jozufozu.flywheel.util.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MonitorRenderer
extends SmartBlockEntityRenderer<MonitorBlockEntity> {
    public MonitorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(MonitorBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, bufferSource, light, overlay);
        if (!blockEntity.isController()) {
            return;
        }
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
        ms.m_85837_(0.5, 0.5, 0.5);
        ms.m_252781_(Axis.f_252392_.m_252977_(direction.m_122435_()));
        ms.m_85837_(-0.5, -0.5, -0.5);
        ms.m_85837_(0.5, 0.5, 0.5);
        ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        ms.m_85837_(-0.5, -0.5, -0.5);
        blockEntity.getRadar().ifPresent(radar -> {
            if (!radar.isRunning()) {
                return;
            }
            this.renderGrid((RadarBearingBlockEntity)((Object)radar), blockEntity, ms, bufferSource);
            this.renderRadarTracks((RadarBearingBlockEntity)((Object)radar), blockEntity, ms, bufferSource);
            this.renderBG(blockEntity, ms, bufferSource, MonitorSprite.RADAR_BG_FILLER);
            this.renderBG(blockEntity, ms, bufferSource, MonitorSprite.RADAR_BG_CIRCLE);
            this.renderSweep((RadarBearingBlockEntity)((Object)radar), blockEntity, ms, bufferSource);
        });
    }

    private void renderGrid(RadarBearingBlockEntity radar, MonitorBlockEntity blockEntity, PoseStack ms, MultiBufferSource bufferSource) {
        int size = blockEntity.getSize();
        float range = radar.getRange();
        int GRID_BLOCK_SIZE = 50;
        float gridSpacing = range / 50.0f;
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.m_110473_((ResourceLocation)MonitorSprite.GRID_SQUARE.getTexture()));
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(0, 255, 0);
        float alpha = 0.5f;
        float deptY = 0.94f;
        float xmin = 1 - size;
        float zmin = 1 - size;
        float xmax = 1.0f;
        float zmax = 1.0f;
        float u0 = -0.5f * gridSpacing;
        float v0 = -0.5f * gridSpacing;
        float u1 = 0.5f * gridSpacing;
        float v1 = -0.5f * gridSpacing;
        float u2 = 0.5f * gridSpacing;
        float v2 = 0.5f * gridSpacing;
        float u3 = -0.5f * gridSpacing;
        float v3 = 0.5f * gridSpacing;
        buffer.m_252986_(m, xmin, deptY, zmin).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, deptY, zmin).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, deptY, zmax).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmin, deptY, zmax).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u3, v3).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderRadarTracks(RadarBearingBlockEntity radar, MonitorBlockEntity monitor, PoseStack ms, MultiBufferSource bufferSource) {
        List<RadarTrack> tracks = radar.getEntityPositions();
        List<VSRadarTracks> vsTracks = radar.getVS2Positions();
        AtomicInteger depthCounter = new AtomicInteger(0);
        tracks.stream().filter(track -> monitor.filter.test(track.entityType())).forEach(track -> this.renderTrack((RadarTrack)track, monitor, radar, ms, bufferSource, depthCounter.getAndIncrement()));
        vsTracks.stream().filter(track -> monitor.filter.test(RadarTrack.EntityType.VS2)).forEach(track -> this.renderVS2Track((VSRadarTracks)track, monitor, radar, ms, bufferSource, depthCounter.getAndIncrement()));
    }

    private void renderTrack(RadarTrack track, MonitorBlockEntity monitor, RadarBearingBlockEntity radar, PoseStack ms, MultiBufferSource bufferSource, int depthMultiplier) {
        float zOff;
        VertexConsumer buffer = this.getBuffer(bufferSource, track.contraption() ? MonitorSprite.CONTRAPTION_HITBOX : MonitorSprite.ENTITY_HITBOX);
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = track.color();
        float alpha = 1.0f;
        float deptY = 0.95f + (float)depthMultiplier * 1.0E-4f;
        float size = monitor.getSize();
        float scale = radar.getRange();
        Direction monitorFacing = (Direction)monitor.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
        Vec3 relativePos = track.position().m_82546_(VS2Utils.getWorldPos((BlockEntity)radar).m_252807_());
        float xOff = monitorFacing.m_122434_() == Direction.Axis.Z ? this.getOffset(relativePos.m_7096_(), scale) : this.getOffset(relativePos.m_7094_(), scale);
        float f = zOff = monitorFacing.m_122434_() == Direction.Axis.Z ? this.getOffset(relativePos.m_7094_(), scale) : this.getOffset(relativePos.m_7096_(), scale);
        if (monitorFacing == Direction.NORTH) {
            xOff = -xOff;
            zOff = -zOff;
        }
        if (monitorFacing == Direction.WEST) {
            zOff = -zOff;
        }
        if (monitorFacing == Direction.EAST) {
            xOff = -xOff;
        }
        if (Math.abs(xOff) > 0.5f || Math.abs(zOff) > 0.5f) {
            return;
        }
        float xmin = 1.0f - size + (xOff *= 0.75f) * size;
        float zmin = 1.0f - size + (zOff *= 0.75f) * size;
        float xmax = xOff * size + 1.0f;
        float zmax = zOff * size + 1.0f;
        float fade = (float)(track.scannedTime() - monitor.m_58904_().m_46467_()) / 100.0f;
        this.renderVertices(buffer, m, n, color, alpha - Math.abs(fade * 0.99f), deptY, xmin, zmin, xmax, zmax);
        if (track.entityId().equals(monitor.hoveredEntity)) {
            this.renderVertices(this.getBuffer(bufferSource, MonitorSprite.TARGET_HOVERED), m, n, new Color(255, 255, 0), alpha, deptY, xmin, zmin, xmax, zmax);
        }
        if (track.entityId().equals(monitor.selectedEntity)) {
            this.renderVertices(this.getBuffer(bufferSource, MonitorSprite.TARGET_SELECTED), m, n, new Color(255, 0, 0), alpha, deptY, xmin, zmin, xmax, zmax);
        }
    }

    private void renderVS2Track(VSRadarTracks track, MonitorBlockEntity monitor, RadarBearingBlockEntity radar, PoseStack ms, MultiBufferSource bufferSource, int depthMultiplier) {
        float zOff;
        VertexConsumer buffer = this.getBuffer(bufferSource, MonitorSprite.CONTRAPTION_HITBOX);
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = track.color();
        float alpha = 1.0f;
        float deptY = 0.95f + (float)depthMultiplier * 1.0E-4f;
        float size = monitor.getSize();
        float scale = radar.getRange();
        Direction monitorFacing = (Direction)monitor.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
        Vec3 relativePos = track.position().m_82546_(VS2Utils.getWorldPos((BlockEntity)radar).m_252807_());
        float xOff = monitorFacing.m_122434_() == Direction.Axis.Z ? this.getOffset(relativePos.m_7096_(), scale) : this.getOffset(relativePos.m_7094_(), scale);
        float f = zOff = monitorFacing.m_122434_() == Direction.Axis.Z ? this.getOffset(relativePos.m_7094_(), scale) : this.getOffset(relativePos.m_7096_(), scale);
        if (monitorFacing == Direction.NORTH) {
            xOff = -xOff;
            zOff = -zOff;
        }
        if (monitorFacing == Direction.WEST) {
            zOff = -zOff;
        }
        if (monitorFacing == Direction.EAST) {
            xOff = -xOff;
        }
        if (Math.abs(xOff) > 0.5f || Math.abs(zOff) > 0.5f) {
            return;
        }
        float xmin = 1.0f - size + (xOff *= 0.75f) * size;
        float zmin = 1.0f - size + (zOff *= 0.75f) * size;
        float xmax = xOff * size + 1.0f;
        float zmax = zOff * size + 1.0f;
        float fade = (float)(track.scannedTime() - monitor.m_58904_().m_46467_()) / 100.0f;
        this.renderVertices(buffer, m, n, color, alpha - Math.abs(fade * 0.99f), deptY, xmin, zmin, xmax, zmax);
        if (track.id().equals(monitor.hoveredEntity)) {
            this.renderVertices(this.getBuffer(bufferSource, MonitorSprite.TARGET_HOVERED), m, n, new Color(255, 255, 0), alpha, deptY, xmin, zmin, xmax, zmax);
        }
        if (track.id().equals(monitor.selectedEntity)) {
            this.renderVertices(this.getBuffer(bufferSource, MonitorSprite.TARGET_SELECTED), m, n, new Color(255, 0, 0), alpha, deptY, xmin, zmin, xmax, zmax);
        }
    }

    private VertexConsumer getBuffer(MultiBufferSource bufferSource, MonitorSprite sprite) {
        return bufferSource.m_6299_(ModRenderTypes.polygonOffset(sprite.getTexture()));
    }

    private float getOffset(double coordinate, float scale) {
        return (float)(coordinate / (double)scale) / 2.0f;
    }

    private void renderVertices(VertexConsumer buffer, Matrix4f m, Matrix3f n, Color color, float alpha, float deptY, float xmin, float zmin, float xmax, float zmax) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        float u3 = 0.0f;
        float v3 = 1.0f;
        buffer.m_252986_(m, xmin, deptY, zmin).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, deptY, zmin).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmax, deptY, zmax).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, xmin, deptY, zmax).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u3, v3).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderBG(MonitorBlockEntity blockEntity, PoseStack ms, MultiBufferSource bufferSource, MonitorSprite monitorSprite) {
        int size = blockEntity.getSize();
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(0, 255, 0);
        float alpha = 0.6f;
        float deptY = 0.94f;
        float minX = 1.0f - (float)size;
        float minZ = 1.0f - (float)size;
        float maxX = 1.0f;
        float maxZ = 1.0f;
        this.renderVertices(this.getBuffer(bufferSource, monitorSprite), m, n, color, alpha, deptY, minX, minZ, maxX, maxZ);
    }

    public void renderSweep(RadarBearingBlockEntity radar, MonitorBlockEntity controller, PoseStack ms, MultiBufferSource bufferSource) {
        if (!radar.isRunning()) {
            return;
        }
        VertexConsumer buffer = bufferSource.m_6299_(ModRenderTypes.polygonOffset(MonitorSprite.RADAR_SWEEP.getTexture()));
        Matrix4f m = ms.m_85850_().m_252922_();
        Matrix3f n = ms.m_85850_().m_252943_();
        Color color = new Color(0, 255, 0);
        float alpha = 0.8f;
        Direction monitorFacing = (Direction)controller.m_58900_().m_61143_((Property)MonitorBlock.f_54117_);
        Direction radarFacing = radar.getReceiverFacing();
        float angleDiff = monitorFacing.m_122435_() - radarFacing.m_122435_();
        float angle = (radar.getAngle() + angleDiff) % 360.0f * (float)Math.PI / 180.0f;
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float centerX = 0.5f;
        float centerY = 0.5f;
        float deptY = 0.945f;
        int size = controller.getSize();
        float u0 = centerX + (0.0f - centerX) * cos - (0.0f - centerY) * sin;
        float v0 = centerY + (0.0f - centerX) * sin + (0.0f - centerY) * cos;
        float u1 = centerX + (1.0f - centerX) * cos - (0.0f - centerY) * sin;
        float v1 = centerY + (1.0f - centerX) * sin + (0.0f - centerY) * cos;
        float u2 = centerX + (1.0f - centerX) * cos - (1.0f - centerY) * sin;
        float v2 = centerY + (1.0f - centerX) * sin + (1.0f - centerY) * cos;
        float u3 = centerX + (0.0f - centerX) * cos - (1.0f - centerY) * sin;
        float v3 = centerY + (0.0f - centerX) * sin + (1.0f - centerY) * cos;
        buffer.m_252986_(m, 1.0f - (float)size, deptY, 1.0f - (float)size).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, 1.0f, deptY, 1.0f - (float)size).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, 1.0f, deptY, 1.0f).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(m, 1.0f - (float)size, deptY, 1.0f).m_85950_(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha).m_7421_(u3, v3).m_86008_(OverlayTexture.f_118083_).m_85969_(255).m_252939_(n, 0.0f, 0.0f, 0.0f).m_5752_();
    }
}

