/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.CreateRadar;
import com.happysg.radar.mixin.AutoCannonAccessor;
import com.simibubi.create.content.contraptions.Contraption;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedAutocannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.ItemCannonBehavior;
import rbasamoyai.createbigcannons.cannons.autocannon.IAutocannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AbstractAutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialProperties;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoItem;
import rbasamoyai.createbigcannons.munitions.autocannon.config.AutocannonProjectilePropertiesComponent;

public class CannonTargeting {
    private static final double DRAG = 0.99;
    private static final double GRAVITY = -0.05;

    public static double calculatePitch(double power, double length, Vec3 cannonPos, Vec3 targetPos) {
        double pitch;
        double dX = targetPos.f_82479_ - cannonPos.f_82479_;
        double dZ = targetPos.f_82481_ - cannonPos.f_82481_;
        double dY = targetPos.f_82480_ - cannonPos.f_82480_;
        double distance = Math.sqrt(dX * dX + dZ * dZ);
        double bestPitch = 0.0;
        double bestAccuracy = Double.MAX_VALUE;
        double pitchIncrement = 0.01;
        for (pitch = -80.0; pitch <= 80.0; pitch += pitchIncrement) {
            double projection;
            double accuracy;
            double airtimeUp = CannonTargeting.computeAirtimeUp(power, pitch, dY, length);
            double airtimeDown = CannonTargeting.computeAirtimeDown(power, pitch, dY, length);
            if (airtimeUp != -1.0 && (accuracy = Math.abs((projection = CannonTargeting.computeProjection(power, pitch, airtimeUp)) - distance)) < bestAccuracy) {
                bestAccuracy = accuracy;
                bestPitch = pitch;
            }
            if (airtimeDown == -1.0 || !((accuracy = Math.abs((projection = CannonTargeting.computeProjection(power, pitch, airtimeDown)) - distance)) < bestAccuracy)) continue;
            bestAccuracy = accuracy;
            bestPitch = pitch;
        }
        double refinedBestPitch = bestPitch;
        bestAccuracy = Double.MAX_VALUE;
        for (pitch = bestPitch - pitchIncrement; pitch <= bestPitch + pitchIncrement; pitch += pitchIncrement / 10.0) {
            double projection;
            double accuracy;
            double airtimeUp = CannonTargeting.computeAirtimeUp(power, pitch, dY, length);
            double airtimeDown = CannonTargeting.computeAirtimeDown(power, pitch, dY, length);
            if (airtimeUp != -1.0 && (accuracy = Math.abs((projection = CannonTargeting.computeProjection(power, pitch, airtimeUp)) - distance)) < bestAccuracy) {
                bestAccuracy = accuracy;
                refinedBestPitch = pitch;
            }
            if (airtimeDown == -1.0 || !((accuracy = Math.abs((projection = CannonTargeting.computeProjection(power, pitch, airtimeDown)) - distance)) < bestAccuracy)) continue;
            bestAccuracy = accuracy;
            refinedBestPitch = pitch;
        }
        CreateRadar.getLogger().info("Best pitch: " + refinedBestPitch);
        return refinedBestPitch;
    }

    private static double computeAirtimeUp(double power, double pitch, double dY, double length) {
        double vertVelocity = power * Math.sin(Math.toRadians(pitch));
        double vertPosition = 0.0;
        if ((dY -= length * Math.sin(Math.toRadians(pitch))) < 0.0) {
            return -1.0;
        }
        double ticks = 0.0;
        do {
            ticks += 1.0;
            vertPosition += vertVelocity;
            vertVelocity = vertVelocity * 0.99 + -0.05;
            if (!(vertPosition > dY)) continue;
            return ticks;
        } while (!(vertVelocity < 0.0));
        return -1.0;
    }

    public static float getSpeed(PitchOrientedContraptionEntity entity) {
        Object v;
        AbstractAutocannonBreechBlockEntity breech;
        Object v2;
        if (entity == null) {
            return 0.0f;
        }
        Contraption contraption = entity.getContraption();
        if (!(contraption instanceof MountedAutocannonContraption)) {
            return 0.0f;
        }
        MountedAutocannonContraption autocannon = (MountedAutocannonContraption)contraption;
        if (autocannon.getStartPos() == null || ((AutoCannonAccessor)autocannon).getMaterial() == null || !((v2 = autocannon.presentBlockEntities.get(autocannon.getStartPos())) instanceof AbstractAutocannonBreechBlockEntity) || !(breech = (AbstractAutocannonBreechBlockEntity)v2).canFire()) {
            return 0.0f;
        }
        ItemStack foundProjectile = breech.extractNextInput();
        Item item = foundProjectile.m_41720_();
        if (!(item instanceof AutocannonAmmoItem)) {
            return 0.0f;
        }
        AutocannonAmmoItem round = (AutocannonAmmoItem)item;
        AutocannonMaterialProperties properties = ((AutoCannonAccessor)autocannon).getMaterial().properties();
        AutocannonProjectilePropertiesComponent roundProperties = round.getAutocannonProperties(foundProjectile);
        boolean canFail = (Boolean)CBCConfigs.SERVER.failure.disableAllFailure.get() == false;
        float speed = properties.baseSpeed();
        boolean canSquib = roundProperties == null || roundProperties.canSquib();
        canSquib &= canFail;
        BlockPos currentPos = autocannon.getStartPos().m_121945_(autocannon.initialOrientation());
        int barrelTravelled = 0;
        while ((v = autocannon.presentBlockEntities.get(currentPos)) instanceof IAutocannonBlockEntity) {
            IAutocannonBlockEntity autocannonI = (IAutocannonBlockEntity)v;
            ItemCannonBehavior behavior = (ItemCannonBehavior)autocannonI.cannonBehavior();
            if (behavior.canLoadItem(foundProjectile)) {
                if (++barrelTravelled <= properties.maxSpeedIncreases()) {
                    speed += properties.speedIncreasePerBarrel();
                }
                if (canSquib && barrelTravelled > properties.maxBarrelLength()) break;
                currentPos = currentPos.m_121945_(autocannon.initialOrientation());
                continue;
            }
            if (!canFail) continue;
            return speed;
        }
        System.out.println("Speed: " + speed);
        System.out.println("barrelTravelled: " + barrelTravelled);
        return speed;
    }

    private static double computeAirtimeDown(double power, double pitch, double dY, double length) {
        block1: {
            double vertVelocity = power * Math.sin(Math.toRadians(pitch));
            double vertPosition = 0.0;
            dY -= length * Math.sin(Math.toRadians(pitch));
            double ticks = 0.0;
            boolean passed = false;
            do {
                ticks += 1.0;
                vertPosition += vertVelocity;
                vertVelocity = vertVelocity * 0.99 + -0.05;
                if (!passed && vertVelocity < 0.0) break block1;
                if (!(vertVelocity > 0.0) || !(vertPosition > dY)) continue;
                passed = true;
            } while (!passed || !(vertVelocity < 0.0) || !(vertPosition < dY));
            return ticks;
        }
        return -1.0;
    }

    private static double computeProjection(double power, double pitch, double airtime) {
        double horizVelocity = power * Math.cos(Math.toRadians(pitch));
        double horizPosition = 0.0;
        int ticks = 1;
        while ((double)ticks <= airtime) {
            horizPosition += horizVelocity;
            horizVelocity *= 0.99;
            ++ticks;
        }
        return horizPosition;
    }
}

