/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.datagenerator.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockItemModelGeneratorProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String modid;
    private final NonNullLazy<List<Block>> blocksToProcess;

    public BlockItemModelGeneratorProvider(DataGenerator generator, String modid, NonNullLazy<List<Block>> blocksToProcess) {
        this.generator = generator;
        this.modid = modid;
        this.blocksToProcess = blocksToProcess;
    }

    private static JsonObject createModel(Block block) {
        JsonObject object = new JsonObject();
        ResourceLocation blockRL = ForgeRegistries.BLOCKS.getKey((Object)block);
        object.addProperty("parent", blockRL.m_135827_() + ":block/" + blockRL.m_135815_());
        return object;
    }

    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
        Path path = this.generator.getPackOutput().m_245114_();
        Path output = path.resolve("assets/" + this.modid + "/models/item/");
        try {
            Files.createDirectories(output, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList futures = new ArrayList();
        ((List)this.blocksToProcess.get()).forEach(blockBase -> futures.add(CompletableFuture.runAsync(() -> {
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(output.resolve(ForgeRegistries.BLOCKS.getKey(blockBase).m_135815_() + ".json"), new OpenOption[0]);){
                bufferedwriter.write(GSON.toJson((JsonElement)BlockItemModelGeneratorProvider.createModel(blockBase)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        })));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @Nonnull
    public String m_6055_() {
        return "Block Model Item Generator (" + this.modid + ")";
    }
}

