/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.energy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageItemStack
implements IEnergyStorage {
    private static final String ENERGY = "stored";
    private static final String MAX = "max";
    private static final String INPUT = "in";
    private static final String OUTPUT = "out";
    private final ItemStack stack;

    public EnergyStorageItemStack(ItemStack stack, int capacity, int in, int out) {
        this.stack = stack;
        boolean hasTags = stack.m_41782_();
        if (!hasTags || !stack.m_41783_().m_128441_("energy")) {
            if (!hasTags) {
                stack.m_41751_(new CompoundTag());
            }
            CompoundTag tag = stack.m_41783_();
            CompoundTag energyTag = new CompoundTag();
            energyTag.m_128405_(ENERGY, 0);
            energyTag.m_128405_(MAX, capacity);
            energyTag.m_128405_(INPUT, in);
            energyTag.m_128405_(OUTPUT, out);
            tag.m_128365_("energy", (Tag)energyTag);
        } else {
            CompoundTag energyTag = this.getStackEnergyTag();
            energyTag.m_128405_(MAX, capacity);
            energyTag.m_128405_(INPUT, in);
            energyTag.m_128405_(OUTPUT, out);
        }
    }

    public void putInternal(int energy) {
        CompoundTag energyTag = this.getStackEnergyTag();
        energyTag.m_128405_(ENERGY, Math.min(energyTag.m_128451_(ENERGY) + energy, energyTag.m_128451_(MAX)));
    }

    private CompoundTag getStackEnergyTag() {
        return this.stack.m_41737_("energy");
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxReceive(), maxReceive));
        if (!simulate && energyReceived != 0) {
            this.getStackEnergyTag().m_128405_("energy", this.getEnergyStored() + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxExtract(), maxExtract));
        if (!simulate && this.stack != null && energyExtracted != 0) {
            this.getStackEnergyTag().m_128405_("energy", this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getMaxExtract() {
        return this.getStackEnergyTag().m_128451_(OUTPUT);
    }

    public int getMaxReceive() {
        return this.getStackEnergyTag().m_128451_(INPUT);
    }

    public int getEnergyStored() {
        return this.getStackEnergyTag().m_128451_(ENERGY);
    }

    public int getMaxEnergyStored() {
        return this.getStackEnergyTag().m_128451_(MAX);
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }
}

