/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.crafting;

import com.github.elenterius.biofactory.init.ModRecipes;
import com.github.elenterius.biofactory.init.biomancy.ArmorUpgrades;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorUpgrades;
import com.simibubi.create.AllItems;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class AcolyteGogglesUpgradeRecipe
extends CustomRecipe {
    public AcolyteGogglesUpgradeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level level) {
        boolean hasHelmet = false;
        boolean hasPrimordialCore = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ModItems.ACOLYTE_ARMOR_HELMET.get()) {
                if (hasHelmet) {
                    return false;
                }
                if (AcolyteArmorUpgrades.hasUpgrade((ItemStack)stack, (AcolyteArmorUpgrades.Upgrade)ArmorUpgrades.ACOLYTE_ENGINEERS_SIGHT_UPGRADE)) {
                    return false;
                }
                hasHelmet = true;
                continue;
            }
            if (item == AllItems.GOGGLES.get()) {
                if (hasPrimordialCore) {
                    return false;
                }
                hasPrimordialCore = true;
                continue;
            }
            return false;
        }
        return hasHelmet && hasPrimordialCore;
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess registryAccess) {
        ItemStack helmet = ItemStack.f_41583_;
        boolean hasPrimordialCore = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ModItems.ACOLYTE_ARMOR_HELMET.get()) {
                if (!helmet.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (AcolyteArmorUpgrades.hasUpgrade((ItemStack)stack, (AcolyteArmorUpgrades.Upgrade)ArmorUpgrades.ACOLYTE_ENGINEERS_SIGHT_UPGRADE)) {
                    return ItemStack.f_41583_;
                }
                helmet = stack;
                continue;
            }
            if (item == AllItems.GOGGLES.get()) {
                if (hasPrimordialCore) {
                    return ItemStack.f_41583_;
                }
                hasPrimordialCore = true;
                continue;
            }
            return ItemStack.f_41583_;
        }
        return hasPrimordialCore && !helmet.m_41619_() ? AcolyteArmorUpgrades.addUpgrade((ItemStack)helmet.m_41777_(), (AcolyteArmorUpgrades.Upgrade)ArmorUpgrades.ACOLYTE_ENGINEERS_SIGHT_UPGRADE) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ACOLYTE_GOGGLES_UPGRADE_SERIALIZER.get();
    }
}

