/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init;

import com.github.elenterius.biofactory.BioFactoryMod;
import com.simibubi.create.content.fluids.VirtualFluid;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"biofactory");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"biofactory");
    public static final RegistryObject<FluidType> NUTRIENTS_TYPE = ModFluids.registerType("nutrients_fluid", properties -> properties);
    public static final Supplier<ForgeFlowingFluid.Properties> NUTRIENTS_FLUID_PROPERTIES = () -> new ForgeFlowingFluid.Properties(NUTRIENTS_TYPE, NUTRIENTS_FLUID, NUTRIENTS_FLUID);
    public static final RegistryObject<ForgeFlowingFluid> NUTRIENTS_FLUID = ModFluids.register("nutrients_fluid", () -> new VirtualFluid(NUTRIENTS_FLUID_PROPERTIES.get()));

    private ModFluids() {
    }

    static void registerInteractions() {
    }

    private static <T extends Fluid> RegistryObject<T> register(String name, Supplier<T> factory) {
        return FLUIDS.register(name, factory);
    }

    private static RegistryObject<FluidType> registerType(final String name, UnaryOperator<FluidType.Properties> operator) {
        return FLUID_TYPES.register(name, () -> new FluidType((FluidType.Properties)operator.apply(ModFluids.createFluidTypeProperties())){
            private final ResourceLocation stillTexture;
            private final ResourceLocation flowingTexture;
            private final ResourceLocation overlayTexture;
            private final ResourceLocation renderOverlayTexture;
            {
                super(properties);
                this.stillTexture = BioFactoryMod.createRL("block/%s_still".formatted(name));
                this.flowingTexture = BioFactoryMod.createRL("block/%s_flowing".formatted(name));
                this.overlayTexture = BioFactoryMod.createRL("block/%s_overlay".formatted(name));
                this.renderOverlayTexture = this.overlayTexture.m_246208_("textures/");
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return flowingTexture;
                    }

                    public ResourceLocation getOverlayTexture() {
                        return overlayTexture;
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return renderOverlayTexture;
                    }
                });
            }
        });
    }

    private static FluidType.Properties createFluidTypeProperties() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }
}

