/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init;

import com.github.elenterius.biofactory.item.NutrientsBottleItem;
import com.github.elenterius.biomancy.api.serum.Serum;
import com.github.elenterius.biomancy.init.ModRarities;
import com.github.elenterius.biomancy.item.SerumItem;
import com.github.elenterius.biomancy.item.SimpleBlockItem;
import com.github.elenterius.biomancy.item.SimpleItem;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"biofactory");
    public static final RegistryObject<NutrientsBottleItem> NUTRIENTS_BOTTLE = ModItems.registerItem("nutrients_fluid_bottle", properties -> new NutrientsBottleItem(properties.m_41487_(16).m_41497_(Rarity.COMMON)));

    private ModItems() {
    }

    public static <T extends Item> Stream<T> findItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T extends Item> Stream<RegistryObject<T>> findEntries(Class<T> clazz) {
        return ITEMS.getEntries().stream().filter(registryObject -> clazz.isInstance(registryObject.get())).map(registryObject -> registryObject);
    }

    private static <T extends Item> RegistryObject<T> registerItem(String name, Function<Item.Properties, T> factory) {
        return ITEMS.register(name, () -> (Item)factory.apply(ModItems.createProperties()));
    }

    private static <T extends Block> RegistryObject<SimpleBlockItem> registerSimpleBlockItem(RegistryObject<T> blockHolder) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> new SimpleBlockItem((Block)blockHolder.get(), ModItems.createProperties()));
    }

    private static <T extends Block> RegistryObject<SimpleBlockItem> registerSimpleBlockItem(RegistryObject<T> blockHolder, Rarity rarity) {
        return ModItems.registerSimpleBlockItem(blockHolder, () -> ModItems.createProperties().m_41497_(rarity));
    }

    private static <T extends Block> RegistryObject<SimpleBlockItem> registerSimpleBlockItem(RegistryObject<T> blockHolder, Supplier<Item.Properties> properties) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> new SimpleBlockItem((Block)blockHolder.get(), (Item.Properties)properties.get()));
    }

    private static <T extends Block, I extends BlockItem> RegistryObject<I> registerBlockItem(RegistryObject<T> blockHolder, Function<T, I> factory) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> (BlockItem)factory.apply((Block)blockHolder.get()));
    }

    private static <T extends Block, I extends BlockItem> RegistryObject<I> registerBlockItem(RegistryObject<T> blockHolder, IBlockItemFactory<T, I> factory) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> factory.create((Block)blockHolder.get(), ModItems.createProperties()));
    }

    private static <T extends Block, I extends BlockItem> RegistryObject<I> registerBlockItem(RegistryObject<T> blockHolder, IBlockItemFactory<T, I> factory, Rarity rarity) {
        return ITEMS.register(blockHolder.getId().m_135815_(), () -> factory.create((Block)blockHolder.get(), ModItems.createProperties().m_41497_(rarity)));
    }

    private static <T extends Serum> RegistryObject<SerumItem> registerSerumItem(RegistryObject<T> registryObject) {
        return ITEMS.register(registryObject.getId().m_135815_(), () -> new SerumItem(ModItems.createProperties().m_41487_(16).m_41497_(ModRarities.UNCOMMON), (Supplier)registryObject));
    }

    private static RegistryObject<SimpleItem> registerSimpleVialItem(String name) {
        return ITEMS.register(name, () -> new SimpleItem(ModItems.createProperties()));
    }

    private static RegistryObject<SimpleItem> registerSimpleItem(String name) {
        return ITEMS.register(name, () -> new SimpleItem(ModItems.createProperties()));
    }

    private static RegistryObject<SimpleItem> registerSimpleItem(String name, Rarity rarity) {
        return ModItems.registerSimpleItem(name, () -> ModItems.createProperties().m_41497_(rarity));
    }

    private static Item.Properties createProperties() {
        return new Item.Properties().m_41497_(ModRarities.COMMON);
    }

    private static RegistryObject<SimpleItem> registerSimpleItem(String name, Supplier<Item.Properties> properties) {
        return ITEMS.register(name, () -> new SimpleItem((Item.Properties)properties.get()));
    }

    static interface IBlockItemFactory<T extends Block, I extends BlockItem> {
        public I create(T var1, Item.Properties var2);
    }
}

