/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init;

import com.github.elenterius.biofactory.crafting.AcolyteGogglesUpgradeRecipe;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"biofactory");
    public static final RegistryObject<RecipeSerializer<AcolyteGogglesUpgradeRecipe>> ACOLYTE_GOGGLES_UPGRADE_SERIALIZER = ModRecipes.registerDynamicCraftingRecipeSerializer(RecipeType.f_44107_, "acolyte_goggles_upgrade", () -> new SimpleCraftingRecipeSerializer(AcolyteGogglesUpgradeRecipe::new));

    private ModRecipes() {
    }

    private static <T extends RecipeType<?>, R extends Recipe<Container>> RegistryObject<RecipeSerializer<R>> registerRecipeSerializer(RegistryObject<T> recipeType, Supplier<RecipeSerializer<R>> serializerSupplier) {
        return RECIPE_SERIALIZERS.register(recipeType.getId().m_135815_(), serializerSupplier);
    }

    private static <T extends RecipeType<?>, R extends Recipe<Container>> RegistryObject<RecipeSerializer<R>> registerDynamicRecipeSerializer(RegistryObject<T> recipeType, String name, Supplier<RecipeSerializer<R>> serializerSupplier) {
        String prefix = recipeType.getId().m_135815_() + "_dynamic_";
        return RECIPE_SERIALIZERS.register(prefix + name, serializerSupplier);
    }

    private static <T extends CraftingRecipe, R extends CraftingRecipe> RegistryObject<RecipeSerializer<R>> registerDynamicCraftingRecipeSerializer(RecipeType<T> recipeType, String name, Supplier<RecipeSerializer<R>> serializerSupplier) {
        String prefix = Objects.requireNonNull(ResourceLocation.m_135820_((String)recipeType.toString())).m_135815_() + "_dynamic_";
        return RECIPE_SERIALIZERS.register(prefix + name, serializerSupplier);
    }

    private static <R extends CraftingRecipe> RegistryObject<RecipeSerializer<R>> registerCraftingRecipeSerializer(String name, Supplier<RecipeSerializer<R>> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }
}

