/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init.biomancy;

import com.github.elenterius.biofactory.init.ModFluids;
import com.github.elenterius.biofactory.init.ModItems;
import com.github.elenterius.biofactory.init.biomancy.ArmorUpgrades;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.api.nutrients.fluid.FluidNutrients;
import com.github.elenterius.biomancy.api.nutrients.fluid.FluidToFuelConversion;
import com.github.elenterius.biomancy.api.tribute.MobEffectTribute;
import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.api.tribute.Tributes;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidToTributeConversion;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidTribute;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidTributes;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.material.Fluid;

public final class BiomancyIntegration {
    public static final int GLASS_BOTTLE_AMOUNT = 250;
    public static final FluidToFuelConversion FLUID_TO_FUEL_CONVERSION = fluidStack -> 100;
    public static final FluidToTributeConversion POTION_FLUID_TO_TRIBUTE_CONVERSION = resource -> {
        CompoundTag tag = resource.getOrCreateTag();
        MobEffectTribute.Builder builder = MobEffectTribute.builder();
        PotionUtils.m_43566_((CompoundTag)tag).forEach(arg_0 -> ((MobEffectTribute.Builder)builder).addEffect(arg_0));
        MobEffectTribute effectTribute = builder.build();
        return FluidTribute.of((Tribute)effectTribute, (int)250);
    };
    private static final Tribute BUILDER_TEA_TRIBUTE = Tributes.combineTributes((Tribute)MobEffectTribute.builder().addEffect(MobEffects.f_19598_, 0, 3600, 1.0f).build(), (Tribute)Tributes.getTribute((ItemStack)Items.f_42455_.m_7968_()));
    private static final FluidTribute BUILDER_TEA_MILLI_TRIBUTE = FluidTribute.of((Tribute)BUILDER_TEA_TRIBUTE, (int)250);
    private static final FluidTribute HONEY_MILLI_TRIBUTE = FluidTribute.of((Tribute)Tributes.getTribute((ItemStack)Items.f_42787_.m_7968_()), (int)250);

    private BiomancyIntegration() {
    }

    public static void onPostSetup() {
        int fuel = BiomancyIntegration.convertToFuelAmount(250);
        Nutrients.registerFuel((Item)((Item)ModItems.NUTRIENTS_BOTTLE.get()), (int)fuel);
        Nutrients.registerRepairMaterial((Item)((Item)ModItems.NUTRIENTS_BOTTLE.get()), (int)(fuel * 2));
        FluidNutrients.register(ModFluids.NUTRIENTS_FLUID, (FluidToFuelConversion)FLUID_TO_FUEL_CONVERSION);
        Tributes.register((Item)((Item)AllItems.BUILDERS_TEA.get()), (Tribute)BUILDER_TEA_TRIBUTE);
        FluidTributes.register((Fluid)((Fluid)AllFluids.TEA.get()), resource -> BUILDER_TEA_MILLI_TRIBUTE);
        FluidTributes.register((Fluid)((Fluid)AllFluids.POTION.get()), (FluidToTributeConversion)POTION_FLUID_TO_TRIBUTE_CONVERSION);
        FluidTributes.register((Fluid)((Fluid)AllFluids.HONEY.get()), resource -> HONEY_MILLI_TRIBUTE);
        ArmorUpgrades.register();
    }

    public static int convertToFluidAmount(ItemStack resource) {
        return Nutrients.getFuelValue((ItemStack)resource) * 1000 / FLUID_TO_FUEL_CONVERSION.getMilliFuelPerUnit(null);
    }

    public static int convertToFuelAmount(int fluidAmount) {
        return fluidAmount * FLUID_TO_FUEL_CONVERSION.getMilliFuelPerUnit(null) / 1000;
    }
}

