/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init.create;

import com.github.elenterius.biofactory.init.ModFluids;
import com.github.elenterius.biomancy.util.CombatUtil;
import com.simibubi.create.content.fluids.OpenEndedPipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public final class EffectHandlers {
    private EffectHandlers() {
    }

    static void register() {
        OpenEndedPipe.registerEffectHandler((OpenEndedPipe.IEffectHandler)new AcidEffectHandler());
        OpenEndedPipe.registerEffectHandler((OpenEndedPipe.IEffectHandler)new NutrientsEffectHandler());
    }

    private static class AcidEffectHandler
    implements OpenEndedPipe.IEffectHandler {
        private AcidEffectHandler() {
        }

        public boolean canApplyEffects(OpenEndedPipe openEndedPipe, FluidStack fluidStack) {
            return fluidStack.getFluid().getFluidType() == com.github.elenterius.biomancy.init.ModFluids.ACID_TYPE.get();
        }

        public void applyEffects(OpenEndedPipe openEndedPipe, FluidStack fluidStack) {
            Level level = openEndedPipe.getWorld();
            if (level.m_46467_() % 5L != 0L) {
                return;
            }
            List mobs = level.m_6443_(LivingEntity.class, openEndedPipe.getAOE(), livingEntity -> !CombatUtil.hasAcidEffect((LivingEntity)livingEntity));
            for (LivingEntity mob : mobs) {
                CombatUtil.applyAcidEffect((LivingEntity)mob, (int)4);
            }
            BlockPos.m_121921_((AABB)openEndedPipe.getAOE()).forEach(pos -> this.corrodeCopper(level, (BlockPos)pos));
        }

        private void corrodeCopper(Level level, BlockPos pos) {
            if (level.f_46441_.m_188501_() >= 0.057f) {
                return;
            }
            BlockState blockState = level.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block instanceof WeatheringCopper) {
                WeatheringCopper weatheringCopper = (WeatheringCopper)block;
                if (WeatheringCopper.m_154904_((Block)block).isPresent()) {
                    weatheringCopper.m_142123_(blockState).ifPresent(state -> level.m_46597_(pos, state));
                }
            }
        }
    }

    private static class NutrientsEffectHandler
    implements OpenEndedPipe.IEffectHandler {
        private NutrientsEffectHandler() {
        }

        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return fluid.getFluid().getFluidType() == ModFluids.NUTRIENTS_TYPE.get();
        }

        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            Level level = pipe.getWorld();
            if (level.m_46467_() % 5L != 0L) {
                return;
            }
            for (Player player : level.m_6443_(Player.class, pipe.getAOE(), LivingEntity::m_6084_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 7, 0, false, false, false));
            }
        }
    }
}

