/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init.create;

import com.github.elenterius.biofactory.BioFactoryMod;
import com.github.elenterius.biomancy.block.cauldron.AcidCauldron;
import com.github.elenterius.biomancy.init.AcidInteractions;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModMobEffects;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.statuseffect.CorrosiveEffect;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.simibubi.create.foundation.utility.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class FanProcessingTypes {
    public static final AcidSplashingType ACID_SPLASHING = FanProcessingTypes.register("acid_splashing", new AcidSplashingType());

    static void register() {
    }

    private static <T extends FanProcessingType> T register(String name, T type) {
        FanProcessingTypeRegistry.register((ResourceLocation)BioFactoryMod.createRL(name), type);
        return type;
    }

    public static class AcidSplashingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            if (level.m_6425_(pos).m_76152_().getFluidType() == ModFluids.ACID_TYPE.get()) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60713_((Block)ModBlocks.ACID_CAULDRON.get()) && ((AcidCauldron)ModBlocks.ACID_CAULDRON.get()).m_142596_(blockState)) {
                return true;
            }
            return blockState.m_60713_((Block)ModBlocks.ACID_FLUID_BLOCK.get());
        }

        public int getPriority() {
            return 450;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            return this.canProcess(stack);
        }

        public boolean canProcess(ItemStack stack) {
            BlockItem blockItem;
            Item item = stack.m_41720_();
            return item instanceof BlockItem && this.canProcess((blockItem = (BlockItem)item).m_40614_());
        }

        protected boolean canProcess(Block block) {
            if (block instanceof WeatheringCopper && WeatheringCopper.m_154904_((Block)block).isPresent()) {
                return true;
            }
            return AcidInteractions.NORMAL_TO_ERODED_BLOCK_CONVERSION.containsKey(block);
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            BlockItem blockItem;
            Block processed;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && (processed = this.process((blockItem = (BlockItem)item).m_40614_())) != null) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                ItemStack resultStack = processed.m_5456_().m_7968_();
                resultStack.m_41764_(stack.m_41613_());
                list.add(resultStack);
                return list;
            }
            return null;
        }

        @Nullable
        protected Block process(Block block) {
            if (block instanceof WeatheringCopper) {
                return WeatheringCopper.m_154904_((Block)block).orElse(null);
            }
            return AcidInteractions.NORMAL_TO_ERODED_BLOCK_CONVERSION.containsKey(block) ? ((BlockState)AcidInteractions.NORMAL_TO_ERODED_BLOCK_CONVERSION.get(block)).m_60734_() : null;
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(3800852).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)7995219, (int)53760, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ModParticleTypes.ACID_BUBBLE.get(), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123772_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CorrosiveEffect effect = (CorrosiveEffect)ModMobEffects.CORROSIVE.get();
                if (effect.m_6584_(livingEntity.f_19797_, 0)) {
                    effect.m_6742_(livingEntity, 0);
                }
            }
        }
    }
}

