/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biofactory.init.create;

import com.github.elenterius.biomancy.block.FullFleshDoorBlock;
import com.github.elenterius.biomancy.block.property.Orientation;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

class FullFleshDoorMovingInteraction
extends SimpleBlockMovingInteraction {
    FullFleshDoorMovingInteraction() {
    }

    protected BlockState handle(@Nullable Player player, Contraption contraption, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (!(block instanceof FullFleshDoorBlock)) {
            return state;
        }
        FullFleshDoorBlock doorBlock = (FullFleshDoorBlock)block;
        state = (BlockState)state.m_61122_((Property)FullFleshDoorBlock.f_52727_);
        this.updateDoorPart(contraption, pos, state, doorBlock);
        this.setDoubleDoorOpen(contraption, pos, state, doorBlock, doorBlock.m_52815_(state));
        if (player != null) {
            SoundEvent soundEvent = doorBlock.m_52815_(state) ? (SoundEvent)ModSoundEvents.FLESH_DOOR_OPEN.get() : (SoundEvent)ModSoundEvents.FLESH_DOOR_CLOSE.get();
            float pitch = player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f;
            this.playSound(player, soundEvent, pitch);
        }
        return state;
    }

    private void updateDoorPart(Contraption contraption, BlockPos pos, BlockState state, FullFleshDoorBlock doorBlock) {
        BlockPos offsetPos = doorBlock.isLowerHalf(state) ? pos.m_7494_() : pos.m_7495_();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(offsetPos);
        BlockState newState = (BlockState)info.f_74676_().m_61124_((Property)FullFleshDoorBlock.f_52727_, (Comparable)Boolean.valueOf(doorBlock.m_52815_(state)));
        this.setContraptionBlockData(contraption.entity, offsetPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
    }

    private void setDoubleDoorOpen(Contraption contraption, BlockPos pos, BlockState state, FullFleshDoorBlock doorBlock, boolean open) {
        BlockPos otherPos;
        DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)FullFleshDoorBlock.f_52728_);
        Orientation orientation = (Orientation)state.m_61143_((Property)FullFleshDoorBlock.ORIENTATION);
        if (orientation.axis == Direction.Axis.X) {
            otherPos = pos.m_121945_(hinge == DoorHingeSide.RIGHT ? Direction.NORTH : Direction.SOUTH);
        } else if (orientation.axis == Direction.Axis.Z) {
            otherPos = pos.m_121945_(hinge == DoorHingeSide.RIGHT ? Direction.WEST : Direction.EAST);
        } else {
            return;
        }
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        if (!info.f_74676_().m_60713_(state.m_60734_())) {
            return;
        }
        if (info.f_74676_().m_61143_((Property)FullFleshDoorBlock.ORIENTATION) != orientation || info.f_74676_().m_61143_((Property)FullFleshDoorBlock.f_52728_) == hinge) {
            return;
        }
        if (doorBlock.m_52815_(info.f_74676_()) != open) {
            BlockState newState = (BlockState)info.f_74676_().m_61124_((Property)FullFleshDoorBlock.f_52727_, (Comparable)Boolean.valueOf(open));
            this.setContraptionBlockData(contraption.entity, otherPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
            this.updateDoorPart(contraption, otherPos, newState, doorBlock);
        }
    }

    protected boolean updateColliders() {
        return true;
    }
}

