/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.common.client.IMixinLoadingOverlay;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DrippyOverlayScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MOJANG_STUDIOS_LOGO_LOCATION = new ResourceLocation("textures/gui/title/mojangstudios.png");
    public float backgroundOpacity = 1.0f;

    public DrippyOverlayScreen() {
        super((Component)Component.m_237119_());
        MixinCache.cachedCurrentLoadingScreenProgress = 0.5f;
        this.forceEnableCustomizations();
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen((Screen)this)) {
            LOGGER.info("[DRIPPY LOADING SCREEN] Force-enabling customizations for DrippyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled((Screen)this, (boolean)true);
        }
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)DrippyOverlayScreen.buildLogoWidget());
        this.m_142416_((GuiEventListener)DrippyOverlayScreen.buildProgressBarWidget());
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        int color;
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen((Screen)this);
        boolean shouldRenderDefaultBackground = layer == null || layer.layoutBase.menuBackgrounds.isEmpty();
        IntSupplier supplier = IMixinLoadingOverlay.getBrandBackgroundDrippy();
        int n = color = supplier != null ? supplier.getAsInt() : 0;
        if (shouldRenderDefaultBackground) {
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
            graphics.m_285944_(RenderType.m_286086_(), 0, 0, this.f_96543_, this.f_96544_, DrippyOverlayScreen.replaceAlpha(color, (int)(this.backgroundOpacity * 255.0f)));
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }
        EventHandler.INSTANCE.postEvent((EventBase)new RenderedScreenBackgroundEvent((Screen)this, graphics));
    }

    private static int replaceAlpha(int color, int alpha) {
        if (alpha > 255) {
            alpha = 255;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        return color & 0xFFFFFF | alpha << 24;
    }

    public static RendererWidget buildLogoWidget() {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int centerX = (int)((double)screenWidth * 0.5);
        int centerY = (int)((double)screenHeight * 0.5);
        double logoHeight = Math.min((double)mc.m_91268_().m_85445_() * 0.75, (double)mc.m_91268_().m_85446_()) * 0.25;
        int logoHeightHalf = (int)(logoHeight * 0.5);
        double logoWidth = logoHeight * 4.0;
        int logoWidthHalf = (int)(logoWidth * 0.5);
        int logoPosX = centerX - logoWidthHalf;
        int logoPosY = centerY - logoHeightHalf;
        return new RendererWidget(logoPosX, logoPosY, logoWidthHalf * 2, logoHeightHalf * 2, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, ((IMixinAbstractWidget)widget).getAlphaFancyMenu());
            graphics.m_280411_(MOJANG_STUDIOS_LOGO_LOCATION, x, y, width / 2, height, -0.0625f, 0.0f, 120, 60, 120, 120);
            graphics.m_280411_(MOJANG_STUDIOS_LOGO_LOCATION, x + width / 2, y, width / 2, height, 0.0625f, 60.0f, 120, 60, 120, 120);
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }).setWidgetIdentifierFancyMenu("mojang_logo");
    }

    public static RendererWidget buildProgressBarWidget() {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        double someDouble1 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double someDouble2 = someDouble1 * 4.0;
        int someInt1 = (int)(someDouble2 * 0.5);
        int someInt2 = (int)((double)screenHeight * 0.8325);
        int barPosX = screenWidth / 2 - someInt1;
        int barPosY = someInt2 - 5;
        int barWidth = someInt1 * 2;
        int barHeight = 10;
        return new RendererWidget(barPosX, barPosY, barWidth, barHeight, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            float currentProgress = 0.5f;
            if (Minecraft.m_91087_().m_91265_() instanceof LoadingOverlay) {
                currentProgress = ((IMixinLoadingOverlay)Minecraft.m_91087_().m_91265_()).getCurrentProgressDrippy();
            }
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            DrippyOverlayScreen.drawProgressBar(graphics, x, y, x + width, y + height, ((IMixinAbstractWidget)widget).getAlphaFancyMenu(), currentProgress);
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }).setWidgetIdentifierFancyMenu("progress_bar");
    }

    private static void drawProgressBar(GuiGraphics graphics, int xMin, int yMin, int xMax, int yMax, float opacity, float currentProgress) {
        int i = Mth.m_14167_((float)((float)(xMax - xMin - 2) * currentProgress));
        int j = Math.round(opacity * 255.0f);
        int k = FastColor.ARGB32.m_13660_((int)j, (int)255, (int)255, (int)255);
        graphics.m_280509_(xMin + 2, yMin + 2, xMin + i, yMax - 2, k);
        graphics.m_280509_(xMin + 1, yMin, xMax - 1, yMin + 1, k);
        graphics.m_280509_(xMin + 1, yMax, xMax - 1, yMax - 1, k);
        graphics.m_280509_(xMin, yMin, xMin + 1, yMax, k);
        graphics.m_280509_(xMax, yMin, xMax - 1, yMax, k);
    }
}

