/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.upgrades;

import dan200.computercraft.impl.PlatformHelper;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface UpgradeBase {
    public ResourceLocation getUpgradeID();

    public String getUnlocalisedAdjective();

    public ItemStack getCraftingItem();

    default public ItemStack getUpgradeItem(CompoundTag upgradeData) {
        return this.getCraftingItem();
    }

    default public CompoundTag getUpgradeData(ItemStack stack) {
        return new CompoundTag();
    }

    default public boolean isItemSuitable(ItemStack stack) {
        CompoundTag craftingShareTag;
        ItemStack crafting = this.getCraftingItem();
        CompoundTag shareTag = PlatformHelper.get().getShareTag(stack);
        if (shareTag == (craftingShareTag = PlatformHelper.get().getShareTag(crafting))) {
            return true;
        }
        if (shareTag == null) {
            return Objects.requireNonNull(craftingShareTag).m_128456_();
        }
        if (craftingShareTag == null) {
            return shareTag.m_128456_();
        }
        return shareTag.equals((Object)craftingShareTag);
    }

    public static String getDefaultAdjective(ResourceLocation id) {
        return Util.m_137492_((String)"upgrade", (ResourceLocation)id) + ".adjective";
    }
}

