/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.upgrades;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.PlatformHelper;
import dan200.computercraft.impl.upgrades.SerialiserWithCraftingItem;
import dan200.computercraft.impl.upgrades.SimpleSerialiser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public abstract class UpgradeDataProvider<T extends UpgradeBase, R extends UpgradeSerialiser<? extends T>>
implements DataProvider {
    private final PackOutput output;
    private final String name;
    private final String folder;
    private final ResourceKey<Registry<R>> registry;
    @Nullable
    private List<T> upgrades;

    protected UpgradeDataProvider(PackOutput output, String name, String folder, ResourceKey<Registry<R>> registry) {
        this.output = output;
        this.name = name;
        this.folder = folder;
        this.registry = registry;
    }

    public final Upgrade<R> simple(ResourceLocation id, R serialiser) {
        if (!(serialiser instanceof SimpleSerialiser)) {
            throw new IllegalStateException(String.valueOf(serialiser) + " must be a simple() seriaiser.");
        }
        return new Upgrade<R>(id, serialiser, s -> {});
    }

    public final Upgrade<R> simpleWithCustomItem(ResourceLocation id, R serialiser, Item item) {
        if (!(serialiser instanceof SerialiserWithCraftingItem)) {
            throw new IllegalStateException(String.valueOf(serialiser) + " must be a simpleWithCustomItem() serialiser.");
        }
        return new Upgrade<R>(id, serialiser, s -> s.addProperty("item", PlatformHelper.get().getRegistryKey(Registries.f_256913_, item).toString()));
    }

    protected abstract void addUpgrades(Consumer<Upgrade<R>> var1);

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path base = this.output.m_245114_().resolve("data");
        HashSet seen = new HashSet();
        ArrayList upgrades = new ArrayList();
        ArrayList futures = new ArrayList();
        this.addUpgrades(upgrade -> {
            if (!seen.add(upgrade.id())) {
                throw new IllegalStateException("Duplicate upgrade " + String.valueOf(upgrade.id()));
            }
            JsonObject json = new JsonObject();
            json.addProperty("type", PlatformHelper.get().getRegistryKey(this.registry, upgrade.serialiser()).toString());
            upgrade.serialise().accept(json);
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)base.resolve(upgrade.id().m_135827_() + "/" + this.folder + "/" + upgrade.id().m_135815_() + ".json")));
            try {
                Object result = upgrade.serialiser().fromJson(upgrade.id(), json);
                upgrades.add(result);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                f_252483_.error("Failed to parse {} {}", new Object[]{this.name, upgrade.id(), e});
            }
        });
        this.upgrades = Collections.unmodifiableList(upgrades);
        return Util.m_143840_(futures);
    }

    public final String m_6055_() {
        return this.name;
    }

    public final R existingSerialiser(ResourceLocation id) {
        UpgradeSerialiser result = (UpgradeSerialiser)PlatformHelper.get().getRegistryObject(this.registry, id);
        if (result == null) {
            throw new IllegalArgumentException("No such serialiser " + String.valueOf(this.registry));
        }
        return (R)result;
    }

    public List<T> getGeneratedUpgrades() {
        if (this.upgrades == null) {
            throw new IllegalStateException("Upgrades have not been generated yet");
        }
        return this.upgrades;
    }

    public record Upgrade<R extends UpgradeSerialiser<?>>(ResourceLocation id, R serialiser, Consumer<JsonObject> serialise) {
        public void add(Consumer<Upgrade<R>> add) {
            add.accept(this);
        }

        public Upgrade<R> requireMod(String modId) {
            return new Upgrade<R>(this.id, this.serialiser, json -> {
                PlatformHelper.get().addRequiredModCondition((JsonObject)json, modId);
                this.serialise.accept((JsonObject)json);
            });
        }
    }
}

