/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;

public class LecternPocketModel {
    public static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("computercraft", "entity/pocket_computer_normal");
    public static final ResourceLocation TEXTURE_ADVANCED = new ResourceLocation("computercraft", "entity/pocket_computer_advanced");
    public static final ResourceLocation TEXTURE_COLOUR = new ResourceLocation("computercraft", "entity/pocket_computer_colour");
    public static final ResourceLocation TEXTURE_FRAME = new ResourceLocation("computercraft", "entity/pocket_computer_frame");
    public static final ResourceLocation TEXTURE_LIGHT = new ResourceLocation("computercraft", "entity/pocket_computer_light");
    private static final Material MATERIAL_NORMAL = new Material(InventoryMenu.f_39692_, TEXTURE_NORMAL);
    private static final Material MATERIAL_ADVANCED = new Material(InventoryMenu.f_39692_, TEXTURE_ADVANCED);
    private static final Material MATERIAL_COLOUR = new Material(InventoryMenu.f_39692_, TEXTURE_COLOUR);
    private static final Material MATERIAL_FRAME = new Material(InventoryMenu.f_39692_, TEXTURE_FRAME);
    private static final Material MATERIAL_LIGHT = new Material(InventoryMenu.f_39692_, TEXTURE_LIGHT);
    public static final float TERM_WIDTH = 0.375f;
    public static final float TERM_HEIGHT = 0.4375f;
    private static final int TEXTURE_WIDTH = 18;
    private static final int TEXTURE_HEIGHT = 18;
    private final ModelPart root = LecternPocketModel.buildPages();

    private static ModelPart buildPages() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        parts.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -5.0f, -4.0f, 1.0f, 10.0f, 8.0f), PartPose.f_171404_);
        return mesh.m_171576_().m_171583_(18, 18);
    }

    private void render(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        int red = FastColor.ARGB32.m_13665_((int)colour);
        int green = FastColor.ARGB32.m_13667_((int)colour);
        int blue = FastColor.ARGB32.m_13669_((int)colour);
        int alpha = FastColor.ARGB32.m_13655_((int)colour);
        this.root.m_104306_(poseStack, buffer, packedLight, packedOverlay, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ComputerFamily family, int frameColour, int lightColour) {
        if (frameColour != -1) {
            this.root.m_104306_(poseStack, MATERIAL_FRAME.m_119194_(bufferSource, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            this.render(poseStack, MATERIAL_COLOUR.m_119194_(bufferSource, RenderType::m_110452_), packedLight, packedOverlay, frameColour);
        } else {
            VertexConsumer buffer = (family == ComputerFamily.ADVANCED ? MATERIAL_ADVANCED : MATERIAL_NORMAL).m_119194_(bufferSource, RenderType::m_110452_);
            this.root.m_104306_(poseStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.render(poseStack, MATERIAL_LIGHT.m_119194_(bufferSource, RenderType::m_110452_), 0xF000F0, packedOverlay, lightColour);
    }
}

