/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import java.util.EnumSet;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public final class MonitorHighlightRenderer {
    private MonitorHighlightRenderer() {
    }

    public static boolean drawHighlight(PoseStack transformStack, MultiBufferSource bufferSource, Camera camera, BlockHitResult hit) {
        BlockPos pos;
        if (camera.m_90592_().m_6047_()) {
            return false;
        }
        Level world = camera.m_90592_().m_20193_();
        BlockEntity tile = world.m_7702_(pos = hit.m_82425_());
        if (!(tile instanceof MonitorBlockEntity)) {
            return false;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
        EnumSet<Direction> faces = EnumSet.allOf(Direction.class);
        Direction front = monitor.getFront();
        faces.remove(front);
        if (monitor.getXIndex() != 0) {
            faces.remove(monitor.getRight().m_122424_());
        }
        if (monitor.getXIndex() != monitor.getWidth() - 1) {
            faces.remove(monitor.getRight());
        }
        if (monitor.getYIndex() != 0) {
            faces.remove(monitor.getDown().m_122424_());
        }
        if (monitor.getYIndex() != monitor.getHeight() - 1) {
            faces.remove(monitor.getDown());
        }
        Vec3 cameraPos = camera.m_90583_();
        transformStack.m_85836_();
        transformStack.m_85837_((double)pos.m_123341_() - cameraPos.m_7096_(), (double)pos.m_123342_() - cameraPos.m_7098_(), (double)pos.m_123343_() - cameraPos.m_7094_());
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110504_());
        Matrix4f transform = transformStack.m_85850_().m_252922_();
        Matrix3f normal = transformStack.m_85850_().m_252943_();
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.WEST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 0.0f, Direction.UP);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.WEST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 1.0f, Direction.UP);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.EAST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 0.0f, 0.0f, Direction.UP);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.EAST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 0.0f, 1.0f, Direction.UP);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 0.0f, Direction.EAST);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 1.0f, Direction.EAST);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 1.0f, 0.0f, Direction.EAST);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 1.0f, 1.0f, Direction.EAST);
        }
        if (faces.contains(Direction.WEST) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.EAST) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 0.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.WEST) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 1.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.EAST) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 1.0f, 0.0f, Direction.SOUTH);
        }
        transformStack.m_85849_();
        return true;
    }

    private static void line(VertexConsumer buffer, Matrix4f transform, Matrix3f normal, float x, float y, float z, Direction direction) {
        buffer.m_252986_(transform, x, y, z).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_252939_(normal, (float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_()).m_5752_();
        buffer.m_252986_(transform, x + (float)direction.m_122429_(), y + (float)direction.m_122430_(), z + (float)direction.m_122431_()).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_252939_(normal, (float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_()).m_5752_();
    }
}

