/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractComputerBlock<T extends AbstractComputerBlockEntity>
extends HorizontalDirectionalBlock
implements IBundledRedstoneBlock,
EntityBlock {
    private static final ResourceLocation DROP = new ResourceLocation("computercraft", "computer");
    protected final RegistryEntry<BlockEntityType<T>> type;
    private final BlockEntityTicker<T> serverTicker = (level, pos, state, computer) -> computer.serverTick();

    protected AbstractComputerBlock(BlockBehaviour.Properties settings, RegistryEntry<BlockEntityType<T>> type) {
        super(settings);
        this.type = type;
    }

    @Deprecated
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)tile;
            computer.updateInputsImmediately();
        }
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction incomingSide) {
        BlockEntity entity = world.m_7702_(pos);
        if (!(entity instanceof AbstractComputerBlockEntity)) {
            return 0;
        }
        AbstractComputerBlockEntity computerEntity = (AbstractComputerBlockEntity)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(incomingSide.m_122424_());
        return computer.getRedstoneOutput(localSide);
    }

    protected abstract ItemStack getItem(AbstractComputerBlockEntity var1);

    @Deprecated
    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction incomingSide) {
        return this.m_6376_(state, world, pos, incomingSide);
    }

    @Override
    public int getBundledRedstoneOutput(Level world, BlockPos pos, Direction side) {
        BlockEntity entity = world.m_7702_(pos);
        if (!(entity instanceof AbstractComputerBlockEntity)) {
            return 0;
        }
        AbstractComputerBlockEntity computerEntity = (AbstractComputerBlockEntity)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    @Deprecated
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        AbstractComputerBlockEntity computer;
        ItemStack result;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof AbstractComputerBlockEntity && !(result = this.getItem(computer = (AbstractComputerBlockEntity)tile)).m_41619_()) {
            return result;
        }
        return super.m_7397_(world, pos, state);
    }

    @Deprecated
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        Object object = params.m_287159_(LootContextParams.f_81462_);
        if (object instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)((Object)object);
            params = params.m_287145_(DROP, out -> out.accept(this.getItem(computer)));
        }
        return super.m_49635_(state, params);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack tool) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        AbstractComputerBlock.m_49892_((BlockState)state, (LevelAccessor)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity tile = world.m_7702_(pos);
        if (!world.f_46443_ && tile instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)tile;
            Item item = stack.m_41720_();
            if (item instanceof IComputerItem) {
                String label;
                IComputerItem item2 = (IComputerItem)item;
                int id = item2.getComputerID(stack);
                if (id != -1) {
                    computer.setComputerID(id);
                }
                if ((label = item2.getLabel(stack)) != null) {
                    computer.setLabel(label);
                }
            }
        }
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!player.m_6047_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)blockEntity;
            if (!level.f_46443_ && computer.isUsable(player)) {
                ServerComputer serverComputer = computer.createServerComputer();
                serverComputer.turnOn();
                PlatformHelper.get().openMenu(player, computer.m_7755_(), computer, new ComputerContainerData(serverComputer, this.getItem(computer)));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Deprecated
    public final void m_6861_(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighborChanged(neighbourPos);
        }
    }

    public final void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighborChanged(neighbour);
        }
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighbourShapeChanged(direction);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(Level level, BlockState state, BlockEntityType<U> type) {
        return level.f_46443_ ? null : BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)this.type.get(), this.serverTicker);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.type.get()).m_155264_(pos, state);
    }
}

