/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import com.google.common.base.Strings;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.media.PrintoutMenu;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PrintoutItem
extends Item {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_PAGES = "Pages";
    private static final String NBT_LINE_TEXT = "Text";
    private static final String NBT_LINE_COLOUR = "Color";
    public static final int LINES_PER_PAGE = 21;
    public static final int LINE_MAX_LENGTH = 25;
    public static final int MAX_PAGES = 16;
    private final Type type;

    public PrintoutItem(Item.Properties settings, Type type) {
        super(settings);
        this.type = type;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag options) {
        String title = PrintoutItem.getTitle(stack);
        if (title != null && !title.isEmpty()) {
            list.add((Component)Component.m_237113_((String)title));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return CustomLecternBlock.defaultUseItemOn(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            String title = PrintoutItem.getTitle(stack);
            Component displayTitle = Strings.isNullOrEmpty((String)title) ? stack.m_41611_() : Component.m_237113_((String)title);
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, p) -> PrintoutMenu.createInHand(id, p, hand), displayTitle));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)world.f_46443_), (Object)stack);
    }

    private ItemStack createFromTitleAndText(@Nullable String title, @Nullable String[] text, @Nullable String[] colours) {
        int i;
        CompoundTag tag;
        ItemStack stack = new ItemStack((ItemLike)this);
        if (title != null) {
            stack.m_41784_().m_128359_(NBT_TITLE, title);
        }
        if (text != null) {
            tag = stack.m_41784_();
            tag.m_128405_(NBT_PAGES, text.length / 21);
            for (i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                tag.m_128359_(NBT_LINE_TEXT + i, text[i]);
            }
        }
        if (colours != null) {
            tag = stack.m_41784_();
            for (i = 0; i < colours.length; ++i) {
                if (colours[i] == null) continue;
                tag.m_128359_(NBT_LINE_COLOUR + i, colours[i]);
            }
        }
        return stack;
    }

    public static ItemStack createSingleFromTitleAndText(@Nullable String title, @Nullable String[] text, @Nullable String[] colours) {
        return ((PrintoutItem)((Object)ModRegistry.Items.PRINTED_PAGE.get())).createFromTitleAndText(title, text, colours);
    }

    public static ItemStack createMultipleFromTitleAndText(@Nullable String title, @Nullable String[] text, @Nullable String[] colours) {
        return ((PrintoutItem)((Object)ModRegistry.Items.PRINTED_PAGES.get())).createFromTitleAndText(title, text, colours);
    }

    public static ItemStack createBookFromTitleAndText(@Nullable String title, @Nullable String[] text, @Nullable String[] colours) {
        return ((PrintoutItem)((Object)ModRegistry.Items.PRINTED_BOOK.get())).createFromTitleAndText(title, text, colours);
    }

    public Type getType() {
        return this.type;
    }

    public static String getTitle(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_TITLE) ? nbt.m_128461_(NBT_TITLE) : "";
    }

    public static int getPageCount(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_PAGES) ? nbt.m_128451_(NBT_PAGES) : 1;
    }

    public static String[] getText(ItemStack stack) {
        return PrintoutItem.getLines(stack, NBT_LINE_TEXT);
    }

    public static String[] getColours(ItemStack stack) {
        return PrintoutItem.getLines(stack, NBT_LINE_COLOUR);
    }

    private static String[] getLines(ItemStack stack, String prefix) {
        CompoundTag nbt = stack.m_41783_();
        int numLines = PrintoutItem.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.m_128461_(prefix + i) : "";
        }
        return lines;
    }

    public static enum Type {
        PAGE,
        PAGES,
        BOOK;

    }
}

