/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.detail.ForgeDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.AbstractFluidMethods;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.util.ArgumentHelpers;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class FluidMethods
extends AbstractFluidMethods<IFluidHandler> {
    @Override
    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> tanks(IFluidHandler fluids) {
        HashMap result = new HashMap();
        int size = fluids.getTanks();
        for (int i = 0; i < size; ++i) {
            FluidStack stack = fluids.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            result.put(i + 1, ForgeDetailRegistries.FLUID_STACK.getBasicDetails(stack));
        }
        return result;
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pushFluid(IFluidHandler from, IComputerAccess computer, String toName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        Fluid fluid = fluidName.isPresent() ? ArgumentHelpers.getRegistryEntry(fluidName.get(), "fluid", RegistryWrappers.FLUIDS) : null;
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IFluidHandler to = FluidMethods.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an tank");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        if (actualLimit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? FluidMethods.moveFluid(from, actualLimit, to) : FluidMethods.moveFluid(from, new FluidStack(fluid, actualLimit), to);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pullFluid(IFluidHandler to, IComputerAccess computer, String fromName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        Fluid fluid = fluidName.isPresent() ? ArgumentHelpers.getRegistryEntry(fluidName.get(), "fluid", RegistryWrappers.FLUIDS) : null;
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IFluidHandler from = FluidMethods.extractHandler(location);
        if (from == null) {
            throw new LuaException("Target '" + fromName + "' is not an tank");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        if (actualLimit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        return fluid == null ? FluidMethods.moveFluid(from, actualLimit, to) : FluidMethods.moveFluid(from, new FluidStack(fluid, actualLimit), to);
    }

    @Nullable
    private static IFluidHandler extractHandler(IPeripheral peripheral) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        Direction direction;
        Object object = peripheral.getTarget();
        if (peripheral instanceof GenericPeripheral) {
            GenericPeripheral sided = (GenericPeripheral)peripheral;
            v0 = sided.side();
        } else {
            v0 = direction = null;
        }
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = CapabilityUtil.getCapability(provider = (ICapabilityProvider)object, ForgeCapabilities.FLUID_HANDLER, direction)).isPresent()) {
            return (IFluidHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)object;
            return handler;
        }
        return null;
    }

    private static int moveFluid(IFluidHandler from, int limit, IFluidHandler to) {
        return FluidMethods.moveFluid(from, from.drain(limit, IFluidHandler.FluidAction.SIMULATE), limit, to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack fluid, IFluidHandler to) {
        return FluidMethods.moveFluid(from, from.drain(fluid, IFluidHandler.FluidAction.SIMULATE), fluid.getAmount(), to);
    }

    private static int moveFluid(IFluidHandler from, FluidStack extracted, int limit, IFluidHandler to) {
        if (extracted.getAmount() <= 0) {
            return 0;
        }
        extracted = extracted.copy();
        extracted.setAmount(Math.min(extracted.getAmount(), limit));
        int inserted = to.fill(extracted.copy(), IFluidHandler.FluidAction.EXECUTE);
        if (inserted <= 0) {
            return 0;
        }
        extracted.setAmount(inserted);
        from.drain(extracted, IFluidHandler.FluidAction.EXECUTE);
        return inserted;
    }
}

