/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockItem;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<CableModemVariant> MODEM = EnumProperty.m_61587_((String)"modem", CableModemVariant.class);
    public static final BooleanProperty CABLE = BooleanProperty.m_61465_((String)"cable");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    static final EnumMap<Direction, BooleanProperty> CONNECTIONS = (EnumMap)Util.m_137469_(new EnumMap(Direction.class), m -> {
        m.put(Direction.DOWN, DOWN);
        m.put(Direction.UP, UP);
        m.put(Direction.NORTH, NORTH);
        m.put(Direction.SOUTH, SOUTH);
        m.put(Direction.WEST, WEST);
        m.put(Direction.EAST, EAST);
    });

    public CableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(MODEM, (Comparable)((Object)CableModemVariant.None))).m_61124_((Property)CABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODEM, CABLE, NORTH, SOUTH, EAST, WEST, UP, DOWN, WaterloggableHelpers.WATERLOGGED});
    }

    public static boolean canConnectIn(BlockState state, Direction direction) {
        return (Boolean)state.m_61143_((Property)CABLE) != false && ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() != direction;
    }

    public static boolean doesConnectVisually(BlockState state, Level level, BlockPos pos, Direction direction) {
        if (!((Boolean)state.m_61143_((Property)CABLE)).booleanValue()) {
            return false;
        }
        if (((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() == direction) {
            return true;
        }
        return PlatformHelper.get().hasWiredElementIn(level, pos, direction);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CableShapes.getShape(state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(world, pos, state, player);
        if (this.onCustomDestroyBlock(state, world, pos, player)) {
            return false;
        }
        return world.m_7731_(pos, fluid.m_76188_(), world.f_46443_ ? 11 : 3);
    }

    public boolean onCustomDestroyBlock(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack item;
        BlockState newState;
        CableBlockEntity cable;
        BlockHitResult hit;
        block9: {
            block8: {
                if (!((Boolean)state.m_61143_((Property)CABLE)).booleanValue() || ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() == null) {
                    return false;
                }
                hit = world.m_45547_(new ClipContext(WorldUtil.getRayStart(player), WorldUtil.getRayEnd(player), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                if (hit.m_6662_() != HitResult.Type.BLOCK) {
                    return false;
                }
                BlockEntity tile = world.m_7702_(pos);
                if (!(tile instanceof CableBlockEntity)) break block8;
                cable = (CableBlockEntity)tile;
                if (tile.m_58898_()) break block9;
            }
            return false;
        }
        if (WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
            newState = (BlockState)state.m_61124_(MODEM, (Comparable)((Object)CableModemVariant.None));
            item = new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get());
        } else {
            newState = (BlockState)state.m_61124_((Property)CABLE, (Comparable)Boolean.valueOf(false));
            item = new ItemStack((ItemLike)ModRegistry.Items.CABLE.get());
        }
        world.m_46597_(pos, CableBlock.correctConnections(world, pos, newState));
        cable.connectionsChanged();
        if (!world.f_46443_ && !player.m_150110_().f_35937_) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)item);
        }
        return true;
    }

    @Deprecated
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)CABLE) != false ? new ItemStack((ItemLike)ModRegistry.Items.CABLE.get()) : new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get());
    }

    public ItemStack getCloneItemStack(BlockState state, @Nullable HitResult hit, BlockGetter world, BlockPos pos, Player player) {
        Direction modem = ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing();
        boolean cable = (Boolean)state.m_61143_((Property)CABLE);
        if (!cable) {
            return new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get());
        }
        if (modem == null) {
            return new ItemStack((ItemLike)ModRegistry.Items.CABLE.get());
        }
        return hit != null && WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) ? new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get()) : new ItemStack((ItemLike)ModRegistry.Items.CABLE.get());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CableBlockEntity cable;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof CableBlockEntity && (cable = (CableBlockEntity)tile).hasCable()) {
            cable.connectionsChanged();
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction side, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        BlockState blockState;
        BlockEntity blockEntity;
        CableModemVariant modem;
        WaterloggableHelpers.updateShape(state, level, pos);
        if (!((Boolean)state.m_61143_((Property)CABLE)).booleanValue() && state.m_61143_(MODEM) == CableModemVariant.None) {
            return this.m_5888_(state).m_76188_();
        }
        Direction dir = ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing();
        if (dir != null && dir.equals((Object)side) && !ModemShapes.canSupport((LevelReader)level, otherPos, side.m_122424_())) {
            BlockEntity blockEntity2;
            if (!((Boolean)state.m_61143_((Property)CABLE)).booleanValue()) {
                return this.m_5888_(state).m_76188_();
            }
            state = (BlockState)state.m_61124_(MODEM, (Comparable)((Object)CableModemVariant.None));
            if (level instanceof Level) {
                Level actualLevel = (Level)level;
                Block.m_49840_((Level)actualLevel, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get()));
            }
            if ((blockEntity2 = level.m_7702_(pos)) instanceof CableBlockEntity) {
                CableBlockEntity cable = (CableBlockEntity)blockEntity2;
                cable.scheduleConnectionsChanged();
            }
        }
        if ((modem = (CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing() == side && modem.isPeripheralOn() && (blockEntity = level.m_7702_(pos)) instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)blockEntity;
            cable.queueRefreshPeripheral();
        }
        if (level instanceof Level) {
            Level actualLevel = (Level)level;
            blockState = (BlockState)state.m_61124_((Property)CONNECTIONS.get(side), (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, actualLevel, pos, side)));
        } else {
            blockState = state;
        }
        return blockState;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = ((CableModemVariant)((Object)state.m_61143_(MODEM))).getFacing();
        if (facing == null) {
            return true;
        }
        return ModemShapes.canSupport(world, pos.m_121945_(facing), facing.m_122424_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(context)));
        if (context.m_43722_().m_41720_() instanceof CableBlockItem.Cable) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            return CableBlock.correctConnections(world, pos, (BlockState)state.m_61124_((Property)CABLE, (Comparable)Boolean.valueOf(true)));
        }
        return (BlockState)state.m_61124_(MODEM, (Comparable)((Object)CableModemVariant.from(context.m_43719_().m_122424_())));
    }

    public static BlockState correctConnections(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)CABLE)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.WEST)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(CableBlock.doesConnectVisually(state, world, pos, Direction.DOWN)));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }

    @Deprecated
    public final InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult interactionResult;
        if (player.m_6047_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            interactionResult = modem.use(player);
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    @Deprecated
    public final void m_6861_(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            modem.neighborChanged(neighbourPos);
        }
    }

    public final void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            modem.neighborChanged(neighbour);
        }
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity modem = (CableBlockEntity)blockEntity;
            modem.blockTick();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModRegistry.BlockEntities.CABLE.get()).m_155264_(pos, state);
    }
}

