/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;

public class TurtleUtil {
    public static ContainerTransfer getOffsetInventory(ITurtleAccess turtle) {
        return PlatformHelper.get().wrapContainer(turtle.getInventory()).rotate(turtle.getSelectedSlot());
    }

    public static ContainerTransfer getSelectedSlot(ITurtleAccess turtle) {
        return PlatformHelper.get().wrapContainer(turtle.getInventory()).singleSlot(turtle.getSelectedSlot());
    }

    public static void storeItemOrDrop(ITurtleAccess turtle, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (turtle.isRemoved()) {
            WorldUtil.dropItemStack(turtle.getLevel(), turtle.getPosition(), null, stack);
            return;
        }
        ItemStack remainder = InventoryUtil.storeItemsFromOffset(turtle.getInventory(), stack, turtle.getSelectedSlot());
        if (remainder.m_41619_()) {
            return;
        }
        WorldUtil.dropItemStack(turtle.getLevel(), turtle.getPosition(), turtle.getDirection().m_122424_(), remainder);
    }

    public static Function<ItemStack, ItemStack> dropConsumer(ITurtleAccess turtle) {
        return stack -> turtle.isRemoved() ? stack : InventoryUtil.storeItemsFromOffset(turtle.getInventory(), stack, turtle.getSelectedSlot());
    }

    public static void stopConsuming(ITurtleAccess turtle) {
        Direction direction = turtle.isRemoved() ? null : turtle.getDirection().m_122424_();
        DropConsumer.clearAndDrop(turtle.getLevel(), turtle.getPosition(), direction);
    }
}

