/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import java.util.Collections;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TurtleBlockEntity
extends AbstractComputerBlockEntity
implements BasicContainer {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> inventorySnapshot = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private boolean inventoryChanged = false;
    private final IntSupplier fuelLimit;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    @Nullable
    private IPeripheral peripheral;
    @Nullable
    private Runnable onMoved;

    public TurtleBlockEntity(BlockEntityType<? extends TurtleBlockEntity> type, BlockPos pos, BlockState state, IntSupplier fuelLimit, ComputerFamily family) {
        super(type, pos, state, family);
        this.fuelLimit = fuelLimit;
    }

    boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = new ServerComputer((ServerLevel)this.m_58904_(), this.m_58899_(), ServerComputer.properties(id, this.getFamily()).label(this.getLabel()).terminalSize(39, 13).addComponent(ComputerComponents.TURTLE, this.brain));
        this.brain.setupComputer(computer);
        return computer;
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    protected int getInteractRange() {
        return 12;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void neighborChanged(BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.neighborChanged(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void loadServer(CompoundTag nbt) {
        super.loadServer(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventorySnapshot.set(i, (Object)((ItemStack)this.inventory.get(i)).m_41777_());
        }
        this.brain.readFromNBT(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt = this.brain.writeToNBT(nbt);
        super.m_183515_(nbt);
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)TurtleBlock.FACING);
    }

    public void setDirection(Direction dir) {
        if (dir.m_122434_() == Direction.Axis.Y) {
            dir = Direction.NORTH;
        }
        this.m_58904_().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TurtleBlock.FACING, (Comparable)dir));
        this.updateRedstone();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    @Nullable
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    public int getColour() {
        return this.brain.getColour();
    }

    @Nullable
    public ResourceLocation getOverlay() {
        return this.brain.getOverlay();
    }

    public ITurtleAccess getAccess() {
        return this.brain;
    }

    public Vec3 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.onTileEntityChange();
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventory;
    }

    public ItemStack getItemSnapshot(int slot) {
        return slot >= 0 && slot < this.inventorySnapshot.size() ? (ItemStack)this.inventorySnapshot.get(slot) : ItemStack.f_41583_;
    }

    public void m_6596_() {
        super.m_6596_();
        for (int slot = 0; slot < this.m_6643_(); ++slot) {
            ItemStack item = this.m_8020_(slot);
            if (ItemStack.m_41728_((ItemStack)item, (ItemStack)((ItemStack)this.inventorySnapshot.get(slot)))) continue;
            this.inventoryChanged = true;
            this.inventorySnapshot.set(slot, (Object)item.m_41777_());
        }
    }

    public boolean m_6542_(Player player) {
        return this.isUsable(player);
    }

    public void onTileEntityChange() {
        super.m_6596_();
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.brain.writeDescription(nbt);
        return nbt;
    }

    @Override
    public void loadClient(CompoundTag nbt) {
        super.loadClient(nbt);
        this.brain.readDescription(nbt);
    }

    public int getFuelLimit() {
        return this.fuelLimit.getAsInt();
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    public void transferStateFrom(TurtleBlockEntity copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.inventorySnapshot, copy.inventorySnapshot);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        if (this.onMoved != null) {
            this.onMoved.run();
        }
    }

    @Nullable
    public IPeripheral peripheral() {
        if (this.hasMoved()) {
            return null;
        }
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("turtle", this);
        return this.peripheral;
    }

    public void onMoved(Runnable onMoved) {
        this.onMoved = onMoved;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return TurtleMenu.ofBrain(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

