/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public final class CapabilityProvider<T>
implements ICapabilityProvider {
    private final Capability<T> cap;
    private final Supplier<T> supplier;
    private final BooleanSupplier isRemoved;
    @Nullable
    private LazyOptional<T> instance;

    private CapabilityProvider(Capability<T> cap, Supplier<T> supplier, BooleanSupplier isRemoved) {
        this.cap = Objects.requireNonNull(cap, "Capability cannot be null");
        this.supplier = supplier;
        this.isRemoved = isRemoved;
    }

    public static <T> CapabilityProvider<T> attach(AttachCapabilitiesEvent<?> event, ResourceLocation id, Capability<T> cap, Supplier<T> instance) {
        BooleanSupplier booleanSupplier;
        Object object = event.getObject();
        if (object instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)object;
            booleanSupplier = () -> ((BlockEntity)be).m_58901_();
        } else {
            object = event.getObject();
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                booleanSupplier = () -> ((Entity)entity).m_213877_();
            } else {
                booleanSupplier = () -> true;
            }
        }
        BooleanSupplier isRemoved = booleanSupplier;
        CapabilityProvider<T> provider = new CapabilityProvider<T>(cap, instance, isRemoved);
        event.addCapability(id, provider);
        event.addListener(provider::invalidate);
        return provider;
    }

    public void invalidate() {
        this.instance = CapabilityUtil.invalidate(this.instance);
    }

    public <U> LazyOptional<U> getCapability(Capability<U> cap, @Nullable Direction side) {
        if (cap != this.cap || this.isRemoved.getAsBoolean()) {
            return LazyOptional.empty();
        }
        LazyOptional instance = this.instance;
        if (instance == null) {
            Object created = this.supplier.get();
            this.instance = created == null ? LazyOptional.empty() : LazyOptional.of(() -> created);
            instance = this.instance;
        }
        return instance.cast();
    }
}

