/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.network;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketGrabbedEntitiesToClient(BlockPos pos, Set<Integer> grabbedEntities) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsbuilder", "grabbed_entities_to_client");

    public PacketGrabbedEntitiesToClient(BlockPos pos, Set<Integer> grabbedEntities) {
        this.pos = pos;
        this.grabbedEntities = new HashSet<Integer>(grabbedEntities);
    }

    public static PacketGrabbedEntitiesToClient create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashSet<Integer> grabbedEntities = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            grabbedEntities.add(buf.readInt());
        }
        BlockPos pos = buf.m_130135_();
        return new PacketGrabbedEntitiesToClient(pos, grabbedEntities);
    }

    public static PacketGrabbedEntitiesToClient create(BlockPos worldPosition, Set<Integer> integers) {
        return new PacketGrabbedEntitiesToClient(worldPosition, integers);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.grabbedEntities.size());
        for (Integer entity : this.grabbedEntities) {
            buf.writeInt(entity.intValue());
        }
        buf.m_130064_(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity patt1956$temp = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (patt1956$temp instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)patt1956$temp;
                mover.getLogic().setGrabbedEntitiesClient(this.grabbedEntities);
            }
        });
    }
}

