/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeDataManagerServer;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public record PacketRequestShapeData(ItemStack card, ShapeID shapeID) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsbuilder", "requestshapedata");

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.card);
        this.shapeID.toBytes(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketRequestShapeData create(FriendlyByteBuf buf) {
        return new PacketRequestShapeData(buf.m_130267_(), new ShapeID(buf));
    }

    public static PacketRequestShapeData create(ItemStack card, ShapeID id) {
        return new PacketRequestShapeData(card, id);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            Shape shape = ShapeCardItem.getShape(this.card);
            boolean solid = ShapeCardItem.isSolid(this.card);
            BlockPos dimension = ShapeCardItem.getDimension(this.card);
            BlockPos clamped = new BlockPos(Math.min(dimension.m_123341_(), 512), Math.min(dimension.m_123342_(), 256), Math.min(dimension.m_123343_(), 512));
            int dy = clamped.m_123342_();
            ItemStack copy = this.card.m_41777_();
            IFormula formula = shape.getFormulaFactory().get();
            formula = formula.correctFormula(solid);
            formula.setup(player.m_9236_(), new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), copy.m_41783_());
            for (int y = 0; y < dy; ++y) {
                ShapeDataManagerServer.pushWork(this.shapeID, copy, y, formula, (ServerPlayer)player);
            }
        }));
    }
}

