/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes.generators;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class MazeGenerator {
    public static CompletableFuture<ChunkAccess> fillFromNoise(ChunkAccess chunkAccess, RFToolsChunkGenerator generator) {
        int minBuildHeight;
        ChunkPos chunkpos = chunkAccess.m_7697_();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Heightmap hmOcean = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap hmWorld = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        BlockState defaultBlock = generator.getDefaultBlock();
        long seed = generator.getSeed();
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        for (int y = minBuildHeight = chunkAccess.m_141937_(); y < 0; ++y) {
            BlockState b = y < minBuildHeight + 2 ? bedrock : defaultBlock;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), b, false);
                }
            }
        }
        for (int cy = 0; cy < 256; cy += 16) {
            int z;
            int x;
            int y;
            boolean isTopOpen = MazeGenerator.isTopOpen(chunkpos.f_45578_, cy, chunkpos.f_45579_, seed);
            boolean isBottomOpen = cy != 0 && MazeGenerator.isTopOpen(chunkpos.f_45578_, cy - 16, chunkpos.f_45579_, seed);
            boolean isEastOpen = MazeGenerator.isEastOpen(chunkpos.f_45578_, cy, chunkpos.f_45579_, seed);
            boolean isWestOpen = MazeGenerator.isEastOpen(chunkpos.f_45578_ - 1, cy, chunkpos.f_45579_, seed);
            boolean isSouthOpen = MazeGenerator.isSouthOpen(chunkpos.f_45578_, cy, chunkpos.f_45579_, seed);
            boolean isNorthOpen = MazeGenerator.isSouthOpen(chunkpos.f_45578_, cy, chunkpos.f_45579_ - 1, seed);
            for (y = cy; y < cy + 4; ++y) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (isBottomOpen && x >= 4 && z >= 4 && x <= 11 && z <= 11) continue;
                        chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                        hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                        hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                    }
                }
            }
            for (y = cy + 4; y < cy + 11; ++y) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (x < 4) {
                            if (isWestOpen && z >= 4 && z <= 11) continue;
                            chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                            hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                            hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                            continue;
                        }
                        if (x > 11) {
                            if (isEastOpen && z >= 4 && z <= 11) continue;
                            chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                            hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                            hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                            continue;
                        }
                        if (z < 4) {
                            if (isNorthOpen) continue;
                            chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                            hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                            hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                            continue;
                        }
                        if (z <= 11 || isSouthOpen) continue;
                        chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                        hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                        hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                    }
                }
            }
            for (y = cy + 11; y < cy + 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (isTopOpen && x >= 4 && z >= 4 && x <= 11 && z <= 11) continue;
                        chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), defaultBlock, false);
                        hmOcean.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                        hmWorld.m_64249_(x, chunkAccess.m_151558_() - 1, z, defaultBlock);
                    }
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    private static boolean isTopOpen(int cx, int cy, int cz, long seed) {
        Random random = new Random((long)cx * 699891043L + (long)cy * 944690531L + (long)cz * 16670002577L ^ seed);
        random.nextFloat();
        return (double)random.nextFloat() < 0.3;
    }

    private static boolean isSouthOpen(int cx, int cy, int cz, long seed) {
        Random random = new Random((long)cx * 944690531L + (long)cy * 34324326931L + (long)cz * 31415927161L ^ seed);
        random.nextFloat();
        return (double)random.nextFloat() < 0.7;
    }

    private static boolean isEastOpen(int cx, int cy, int cz, long seed) {
        Random random = new Random((long)cx * 217185461L + (long)cy * 9899947L + (long)cz * 342432435349L ^ seed);
        random.nextFloat();
        return (double)random.nextFloat() < 0.7;
    }

    public static int getBaseHeight(int pX, int pZ, LevelHeightAccessor level) {
        return 256;
    }

    @NotNull
    public static NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor level, RFToolsChunkGenerator generator) {
        Object[] states = new BlockState[MazeGenerator.getBaseHeight(pX, pZ, level) - level.m_141937_()];
        Arrays.fill(states, generator.getDefaultBlock());
        states[0] = Blocks.f_50752_.m_49966_();
        states[1] = Blocks.f_50752_.m_49966_();
        return new NoiseColumn(level.m_141937_(), (BlockState[])states);
    }
}

