/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes.generators;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class SpikesGenerator {
    @NotNull
    public static CompletableFuture<ChunkAccess> fillFromNoise(ChunkAccess chunkAccess, RFToolsChunkGenerator generator) {
        ChunkPos chunkpos = chunkAccess.m_7697_();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Heightmap hmOcean = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap hmWorld = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        int minBuildHeight = chunkAccess.m_141937_();
        BlockState defaultBlock = generator.getDefaultBlock();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int realx = chunkpos.f_45578_ * 16 + x;
                int realz = chunkpos.f_45579_ * 16 + z;
                int height = SpikesGenerator.calculateSpikeHeight(realx, realz, generator.getSeed());
                for (int y = minBuildHeight; y < height; ++y) {
                    BlockState b = y < minBuildHeight + 2 ? bedrock : defaultBlock;
                    chunkAccess.m_6978_((BlockPos)mpos.m_122178_(x, y, z), b, false);
                    hmOcean.m_64249_(x, y, z, b);
                    hmWorld.m_64249_(x, y, z, b);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    @NotNull
    public static NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor level, RFToolsChunkGenerator generator) {
        Object[] states = new BlockState[SpikesGenerator.calculateSpikeHeight(pX, pZ, generator.getSeed()) - level.m_141937_()];
        Arrays.fill(states, generator.getDefaultBlock());
        states[0] = Blocks.f_50752_.m_49966_();
        states[1] = Blocks.f_50752_.m_49966_();
        return new NoiseColumn(level.m_141937_(), (BlockState[])states);
    }

    public static int calculateSpikeHeight(int pX, int pZ, long seed) {
        Random random = new Random((long)pX * 65657771L + (long)pZ * 56548073L ^ seed);
        random.nextFloat();
        return random.nextInt(100) + 20;
    }
}

