/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.dimlets.recipes.DimletRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class DimletRecipeSerializer
implements RecipeSerializer<DimletRecipe> {
    private final ShapedRecipe.Serializer serializer = new ShapedRecipe.Serializer();

    @Nonnull
    public DimletRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ShapedRecipe recipe = this.serializer.m_6729_(recipeId, json);
        String typeString = json.getAsJsonPrimitive("dimlettype").getAsString();
        DimletType type = DimletType.byName(typeString);
        String key = json.getAsJsonPrimitive("dimletkey").getAsString();
        return new DimletRecipe(recipe, new DimletKey(type, key));
    }

    public DimletRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        ShapedRecipe recipe = this.serializer.m_8005_(recipeId, buffer);
        String typeString = buffer.m_130136_(Short.MAX_VALUE);
        DimletType type = DimletType.byName(typeString);
        String key = buffer.m_130136_(Short.MAX_VALUE);
        return new DimletRecipe(recipe, new DimletKey(type, key));
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, DimletRecipe recipe) {
        this.serializer.m_6178_(buffer, recipe.getRecipe());
        buffer.m_130070_(recipe.getKey().type().name());
        buffer.m_130070_(recipe.getKey().key());
    }
}

