/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class CameraShakeData {
    final int duration;
    final float radius;
    int tickCount;
    final Vec3 origin;

    public CameraShakeData(int duration, Vec3 origin, float radius) {
        this.duration = duration;
        this.origin = origin;
        this.radius = radius;
    }

    public void serializeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.duration);
        buf.writeInt(this.tickCount);
        buf.writeInt((int)(this.origin.f_82479_ * 10.0));
        buf.writeInt((int)(this.origin.f_82480_ * 10.0));
        buf.writeInt((int)(this.origin.f_82481_ * 10.0));
        buf.writeInt((int)(this.radius * 10.0f));
    }

    public static CameraShakeData deserializeFromBuffer(FriendlyByteBuf buf) {
        int duration = buf.readInt();
        int tickCount = buf.readInt();
        Vec3 origin = new Vec3((double)((float)buf.readInt() / 10.0f), (double)((float)buf.readInt() / 10.0f), (double)((float)buf.readInt() / 10.0f));
        float radius = (float)buf.readInt() / 10.0f;
        CameraShakeData data = new CameraShakeData(duration, origin, radius);
        data.tickCount = tickCount;
        return data;
    }
}

