/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.client.AbstractTextKeyParsingClientLootTable;
import fzzyhmstrs.emi_loot.client.ClientRawPool;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ClientMobLootTable
extends AbstractTextKeyParsingClientLootTable<ClientMobLootTable> {
    public static ClientMobLootTable INSTANCE = new ClientMobLootTable();
    private static final ResourceLocation EMPTY = new ResourceLocation("entity/empty");
    public final ResourceLocation id;
    public final ResourceLocation mobId;
    public String color = "";

    public ClientMobLootTable() {
        this.id = EMPTY;
        this.mobId = new ResourceLocation("empty");
    }

    public ClientMobLootTable(ResourceLocation id, ResourceLocation mobId, Map<List<TextKey>, ClientRawPool> map) {
        super(map);
        this.id = id;
        String ns = id.m_135827_();
        String pth = id.m_135815_();
        if (!BuiltInRegistries.f_256780_.m_7804_(mobId)) {
            this.mobId = new ResourceLocation("empty");
        } else {
            int lastSlashIndex;
            if (Objects.equals(mobId, BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20520_)) && (lastSlashIndex = pth.lastIndexOf(47)) != -1) {
                this.color = pth.substring(Math.min(lastSlashIndex + 1, pth.length()));
            }
            this.mobId = mobId;
        }
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return Objects.equals(this.id, EMPTY);
    }

    @Override
    void getSpecialTextKeyList(Level world, Block block, List<Tuple<Integer, Component>> inputList) {
    }

    @Override
    Tuple<ResourceLocation, ResourceLocation> getBufId(FriendlyByteBuf buf) {
        ResourceLocation id = ClientMobLootTable.getIdFromBuf(buf);
        ResourceLocation mobId = ClientMobLootTable.getIdFromBuf(buf);
        return new Tuple((Object)id, (Object)mobId);
    }

    @Override
    ClientMobLootTable simpleTableToReturn(Tuple<ResourceLocation, ResourceLocation> ids, FriendlyByteBuf buf) {
        ClientRawPool simplePool = new ClientRawPool(new HashMap<List<TextKey>, Object2FloatMap<ItemStack>>());
        Object2FloatOpenHashMap simpleMap = new Object2FloatOpenHashMap();
        ItemStack simpleStack = new ItemStack((ItemLike)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_));
        simpleMap.put((Object)simpleStack, 100.0f);
        simplePool.map().put(new ArrayList(), (Object2FloatMap<ItemStack>)simpleMap);
        HashMap<List<TextKey>, ClientRawPool> itemMap = new HashMap<List<TextKey>, ClientRawPool>();
        itemMap.put(new ArrayList(), simplePool);
        return new ClientMobLootTable((ResourceLocation)ids.m_14418_(), (ResourceLocation)ids.m_14419_(), itemMap);
    }

    @Override
    ClientMobLootTable emptyTableToReturn() {
        return new ClientMobLootTable();
    }

    @Override
    ClientMobLootTable filledTableToReturn(Tuple<ResourceLocation, ResourceLocation> ids, Map<List<TextKey>, ClientRawPool> itemMap) {
        return new ClientMobLootTable((ResourceLocation)ids.m_14418_(), (ResourceLocation)ids.m_14419_(), itemMap);
    }
}

