/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClientAgnos;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.EntityEmiStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.SymbolText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class MobLootRecipe
implements EmiRecipe {
    private static final ResourceLocation ARROW_ID = new ResourceLocation("emi_loot", "textures/gui/downturn_arrow.png");
    private final ResourceLocation lootId;
    private final EmiStack inputStack;
    private final List<EmiStack> outputStacks;
    private final TrimmedTitle name;
    private final EntityType<?> type;
    @Nullable
    private final EmiStack egg;
    private final List<WidgetRowBuilder> rowBuilderList = new ArrayList<WidgetRowBuilder>();

    public MobLootRecipe(ClientMobLootTable loot) {
        MutableComponent rawTitle;
        EntityType type;
        this.lootId = loot.id;
        loot.build((Level)Minecraft.m_91087_().f_91073_, Blocks.f_50016_);
        ResourceLocation mobId = loot.mobId;
        this.type = type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(mobId);
        SpawnEggItem eggItem = SpawnEggItem.m_43213_((EntityType)type);
        this.egg = eggItem != null ? EmiStack.of((ItemLike)eggItem) : null;
        Minecraft client = Minecraft.m_91087_();
        Entity entity = type.m_20615_((Level)client.f_91073_);
        if (entity != null) {
            AABB box = entity.m_20191_();
            double len = box.m_82309_();
            if (len > 1.05) {
                len = (len + Math.sqrt(len)) / 2.0;
            }
            if (entity instanceof Slime) {
                ((Slime)entity).m_7839_(5, false);
            }
            if (entity instanceof Sheep && !Objects.equals(loot.color, "")) {
                DyeColor color = DyeColor.m_41057_((String)loot.color, (DyeColor)DyeColor.WHITE);
                MutableComponent colorName = LText.translatable("color.minecraft." + color.m_41065_());
                rawTitle = LText.translatable("emi_loot.color_name", colorName.getString(), entity.m_7755_().getString());
                ((Sheep)entity).m_29855_(color);
            } else {
                rawTitle = entity.m_7755_();
            }
            double scale = 1.05 / len * 8.0;
            if (ClientResourceData.MOB_SCALES.containsKey((Object)type)) {
                scale *= (double)ClientResourceData.MOB_SCALES.getOrDefault((Object)type, 1.0f);
            }
            this.inputStack = EntityEmiStack.ofScaled(entity, scale);
        } else {
            this.inputStack = EmiStack.EMPTY;
            rawTitle = LText.translatable("emi_loot.missing_entity");
        }
        this.name = TrimmedTitle.of((Component)rawTitle, (EMILoot.config.isTooltipStyle() ? 138 : 158) - (this.egg != null ? 49 : 30));
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stacks().forEach(cs -> list.addAll(cs.ingredient()));
            try {
                this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
            }
            catch (Throwable e) {
                EMILoot.LOGGER.error("Error encountered while preparing layout for mob recipe {}, display may be incomplete.", (Object)loot.id);
                e.printStackTrace();
            }
        });
        this.outputStacks = list;
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            return;
        }
        Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
        if (opt.isEmpty()) {
            return;
        }
        this.addWidgetBuilders(opt.get(), true);
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.MOB_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("emi_loot", "/" + this.getCategory().id.m_135815_() + "/" + this.lootId.m_135827_() + "/" + this.lootId.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return this.egg != null ? List.of(this.egg) : Collections.emptyList();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return EMILoot.config.isTooltipStyle() ? 144 : 154;
    }

    public int getDisplayHeight() {
        if (EMILoot.config.isTooltipStyle()) {
            int stacks = this.outputStacks.size();
            if (stacks <= 4) {
                return 29;
            }
            if (EMILoot.config.isCompact(EMILoot.Type.MOB)) {
                int ingredients = 0;
                for (WidgetRowBuilder builder : this.rowBuilderList) {
                    ingredients += builder.ingredientCount();
                }
                if (ingredients <= 4) {
                    return 29;
                }
                return 29 + 18 * ((ingredients - 5) / 8 + 1);
            }
            return 29 + 18 * ((stacks - 5) / 8 + 1);
        }
        if (this.rowBuilderList.size() > 1 || this.rowBuilderList.get(0).getWidth() > 94) {
            return 51 + 29 * (this.rowBuilderList.size() - 1);
        }
        return 34;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = 0;
        int y = 0;
        if (!ClientResourceData.MOB_OFFSETS.containsKey(this.type)) {
            widgets.addSlot((EmiIngredient)this.inputStack, x, y).large(true);
        } else {
            int offset = ClientResourceData.MOB_OFFSETS.getOrDefault(this.type, 0);
            widgets.addTexture(EmiTexture.LARGE_SLOT, x, y);
            widgets.addDrawable(x, y, 16, 16, (matrices, mx, my, delta) -> this.inputStack.render(matrices, 5, 6 + offset, delta));
            widgets.addTooltip(this.inputStack.getTooltip(), x, y, 24, 24);
        }
        if (this.egg == null) {
            widgets.addText(this.name.title(), 30, 0, 0x404040, false);
            if (this.name.trimmed()) {
                widgets.addTooltipText(List.of(this.name.rawTitle()), 30, 0, EMILoot.config.isTooltipStyle() ? 108 : 118, 10);
            }
        } else {
            widgets.addText(this.name.title(), 49, 0, 0x404040, false);
            if (this.name.trimmed()) {
                widgets.addTooltipText(List.of(this.name.rawTitle()), 30, 0, EMILoot.config.isTooltipStyle() ? 89 : 99, 10);
            }
            widgets.addSlot((EmiIngredient)this.egg, 28, 0);
        }
        if (EMILoot.config.isTooltipStyle()) {
            if (this.egg == null) {
                widgets.addTexture(new EmiTexture(ARROW_ID, 0, 16, 28, 15, 28, 15, 64, 32), 30, 10);
            } else {
                widgets.addTexture(new EmiTexture(ARROW_ID, 32, 16, 28, 15, 28, 15, 64, 32), 28, 15);
            }
            List stacks = this.outputStacks.size() <= 4 || !EMILoot.config.isCompact(EMILoot.Type.MOB) ? (List)this.rowBuilderList.stream().map(WidgetRowBuilder::stacks).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll) : (List)this.rowBuilderList.stream().map(WidgetRowBuilder::ingredients).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
            int i = 4;
            int j = 0;
            for (ConditionalStack stack : stacks) {
                SlotWidget widget = widgets.addSlot(stack.getIngredient(), i * 18, 11 + 18 * j);
                String rounded = FloatTrimmer.trimFloatString(Math.max(stack.weight() / 100.0f, 0.01f), (Integer)EMILoot.config.chanceDecimalPlaces.get());
                widget.appendTooltip((Component)FcText.INSTANCE.translatable("emi_loot.rolls", new Object[]{rounded}).m_130940_(ChatFormatting.GRAY));
                if (EMILoot.config.isNotPlain()) {
                    for (Tuple<Integer, Component> pair : stack.conditions()) {
                        widget.appendTooltip((Component)SymbolText.of((Integer)pair.m_14418_(), (Component)pair.m_14419_()));
                    }
                }
                if (++i <= 7) continue;
                i = 0;
                ++j;
            }
        } else if (this.rowBuilderList.size() == 1 && this.rowBuilderList.get(0).getWidth() <= 94) {
            if (this.egg == null) {
                widgets.addTexture(new EmiTexture(ARROW_ID, 0, 16, 27, 15, 27, 15, 64, 32), 30, 10);
            } else {
                widgets.addTexture(new EmiTexture(ARROW_ID, 32, 16, 28, 15, 28, 15, 64, 32), 28, 15);
            }
            x = 60;
            y = 11;
            WidgetRowBuilder builder = this.rowBuilderList.get(0);
            for (ClientBuiltPool pool : builder.getPoolList()) {
                IconGroupEmiWidget widget = EMILootClientAgnos.createIconGroupEmiWidget(x, y, pool);
                widgets.add((Widget)widget);
                x += widget.getWidth() + 6;
            }
        } else {
            if (this.egg == null) {
                widgets.addTexture(new EmiTexture(ARROW_ID, 0, 0, 39, 15, 39, 15, 64, 32), 30, 10);
            } else {
                widgets.addTexture(new EmiTexture(ARROW_ID, 0, 0, 39, 15, 39, 15, 64, 32), 49, 10);
            }
            y += 28;
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = EMILootClientAgnos.createIconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 0;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

