/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.EntityPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.DistancePredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityEffectPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityEquipmentPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityFlagsPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityTypePredicateParser;
import fzzyhmstrs.emi_loot.parser.LocationPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.NbtPredicateParser;
import fzzyhmstrs.emi_loot.parser.TypeSpecificPredicateParser;
import fzzyhmstrs.emi_loot.util.LText;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.network.chat.Component;

public class EntityPredicateParser {
    public static Component parseEntityPredicate(EntityPredicate predicate) {
        return LText.translatable("emi_loot.entity_predicate.base", EntityPredicateParser.parseEntityPredicateInternal(predicate).getString());
    }

    private static Component parseEntityPredicateInternal(EntityPredicate predicate) {
        if (predicate.equals(EntityPredicate.f_36550_)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Entity predicate empty in table: " + LootTableParser.currentTable);
            }
            return LText.empty();
        }
        EntityTypePredicate typePredicate = ((EntityPredicateAccessor)predicate).getType();
        if (!typePredicate.equals(EntityTypePredicate.f_37636_)) {
            return EntityTypePredicateParser.parseEntityTypePredicate(typePredicate);
        }
        DistancePredicate distancePredicate = ((EntityPredicateAccessor)predicate).getDistance();
        if (!distancePredicate.equals(DistancePredicate.f_26241_)) {
            return DistancePredicateParser.parseDistancePredicate(distancePredicate);
        }
        LocationPredicate locationPredicate = ((EntityPredicateAccessor)predicate).getLocation();
        if (!locationPredicate.equals(LocationPredicate.f_52592_)) {
            return LocationPredicateParser.parseLocationPredicate(locationPredicate);
        }
        LocationPredicate steppingOnPredicate = ((EntityPredicateAccessor)predicate).getSteppingOn();
        if (!steppingOnPredicate.equals(LocationPredicate.f_52592_)) {
            return LocationPredicateParser.parseLocationPredicate(locationPredicate);
        }
        MobEffectsPredicate entityEffectPredicate = ((EntityPredicateAccessor)predicate).getEffects();
        if (!entityEffectPredicate.equals(MobEffectsPredicate.f_56547_)) {
            return EntityEffectPredicateParser.parseEntityEffectPredicate(entityEffectPredicate);
        }
        NbtPredicate nbt = ((EntityPredicateAccessor)predicate).getNbt();
        if (!nbt.equals(NbtPredicate.f_57471_)) {
            return NbtPredicateParser.parseNbtPredicate(nbt);
        }
        EntityFlagsPredicate entityFlagsPredicate = ((EntityPredicateAccessor)predicate).getFlags();
        if (!entityFlagsPredicate.equals(EntityFlagsPredicate.f_33682_)) {
            return EntityFlagsPredicateParser.parseEntityFlagsPredicate(entityFlagsPredicate);
        }
        EntityEquipmentPredicate entityEquipmentPredicate = ((EntityPredicateAccessor)predicate).getEquipment();
        if (!entityEquipmentPredicate.equals(EntityEquipmentPredicate.f_32176_)) {
            return EntityEquipmentPredicateParser.parseEntityEquipmentPredicate(entityEquipmentPredicate);
        }
        EntitySubPredicate typeSpecificPredicate = ((EntityPredicateAccessor)predicate).getTypeSpecific();
        if (!typeSpecificPredicate.equals((Object)EntitySubPredicate.f_218826_)) {
            return TypeSpecificPredicateParser.parseTypeSpecificPredicate(typeSpecificPredicate);
        }
        EntityPredicate vehicle = ((EntityPredicateAccessor)predicate).getVehicle();
        if (!vehicle.equals(EntityPredicate.f_36550_)) {
            return EntityPredicateParser.parseEntityPredicate(vehicle);
        }
        EntityPredicate passenger = ((EntityPredicateAccessor)predicate).getPassenger();
        if (!passenger.equals(EntityPredicate.f_36550_)) {
            return EntityPredicateParser.parseEntityPredicate(passenger);
        }
        EntityPredicate targetedEntity = ((EntityPredicateAccessor)predicate).getTargetedEntity();
        if (!targetedEntity.equals(EntityPredicate.f_36550_)) {
            return EntityPredicateParser.parseEntityPredicate(targetedEntity);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Entity predicate undefined in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

